/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.extensions.internals;

import ai.h2o.sparkling.extensions.internals.CategoricalConstants;
import ai.h2o.sparkling.extensions.internals.LocalNodeDomains;
import java.util.Arrays;
import jsr166y.ForkJoinTask;
import water.H2O;
import water.Key;
import water.MRTask;
import water.parser.BufferedString;
import water.parser.PackedDomains;
import water.util.Log;

public class CollectCategoricalDomainsTask
extends MRTask<CollectCategoricalDomainsTask> {
    private final Key frameKey;
    private byte[][] packedDomains;
    private int maximumCategoricalLevels;

    public CollectCategoricalDomainsTask(Key frameKey) {
        this.frameKey = frameKey;
        this.maximumCategoricalLevels = CategoricalConstants.getMaximumCategoricalLevels();
    }

    public void setupLocal() {
        if (!LocalNodeDomains.containsDomains(this.frameKey)) {
            return;
        }
        String[][][] localDomains = LocalNodeDomains.getDomains(this.frameKey);
        if (localDomains.length == 0) {
            return;
        }
        this.packedDomains = this.chunkDomainsToPackedDomains(localDomains[0]);
        for (int i = 1; i < localDomains.length; ++i) {
            byte[][] anotherPackedDomains = this.chunkDomainsToPackedDomains(localDomains[i]);
            this.mergePackedDomains(this.packedDomains, anotherPackedDomains);
        }
        Log.trace((Object[])new Object[]{"Done locally collecting domains on each node."});
    }

    private byte[][] chunkDomainsToPackedDomains(String[][] domains) {
        byte[][] result = new byte[domains.length][];
        for (int i = 0; i < domains.length; ++i) {
            String[] columnDomain = domains[i];
            if (columnDomain.length > this.maximumCategoricalLevels) {
                result[i] = null;
                continue;
            }
            Object[] values = BufferedString.toBufferedString((String[])columnDomain);
            Arrays.sort(values);
            result[i] = PackedDomains.pack((BufferedString[])values);
        }
        return result;
    }

    private void mergePackedDomains(byte[][] target, byte[][] source) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = (byte[])(target[i] == null || source[i] == null ? null : (byte[])(target[i].length + source[i].length > this.maximumCategoricalLevels ? null : PackedDomains.merge((byte[])target[i], (byte[])source[i])));
        }
    }

    public void reduce(final CollectCategoricalDomainsTask other) {
        if (this.packedDomains == null) {
            this.packedDomains = other.packedDomains;
        } else if (other.packedDomains != null) {
            H2O.H2OCountedCompleter[] tasks = new H2O.H2OCountedCompleter[this.packedDomains.length];
            for (int i = 0; i < this.packedDomains.length; ++i) {
                final int fi = i;
                tasks[i] = new H2O.H2OCountedCompleter(CollectCategoricalDomainsTask.currThrPriority()){

                    public void compute2() {
                        ((CollectCategoricalDomainsTask)CollectCategoricalDomainsTask.this).packedDomains[fi] = (byte[])(CollectCategoricalDomainsTask.this.packedDomains[fi] == null || other.packedDomains[fi] == null ? null : (byte[])(PackedDomains.sizeOf((byte[])CollectCategoricalDomainsTask.this.packedDomains[fi]) + PackedDomains.sizeOf((byte[])other.packedDomains[fi]) > CollectCategoricalDomainsTask.this.maximumCategoricalLevels ? null : PackedDomains.merge((byte[])CollectCategoricalDomainsTask.this.packedDomains[fi], (byte[])other.packedDomains[fi])));
                        this.tryComplete();
                    }
                };
            }
            ForkJoinTask.invokeAll((ForkJoinTask[])tasks);
        }
        Log.trace((Object[])new Object[]{"Done merging domains."});
    }

    public String[][] getDomains() {
        if (this.packedDomains == null) {
            return null;
        }
        String[][] result = new String[this.packedDomains.length][];
        for (int i = 0; i < this.packedDomains.length; ++i) {
            result[i] = this.packedDomains[i] == null ? null : PackedDomains.unpackToStrings((byte[])this.packedDomains[i]);
        }
        return result;
    }
}

