/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.extensions.internals;

import ai.h2o.sparkling.extensions.internals.LocalNodeDomains;
import water.H2O;
import water.Key;
import water.MRTask;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.NewChunk;

public class ConvertCategoricalToStringColumnsTask
extends MRTask<ConvertCategoricalToStringColumnsTask> {
    private final Key frameKey;
    private final int[] domainIndices;

    public ConvertCategoricalToStringColumnsTask(Key frameKey, int[] domainIndices) {
        this.frameKey = frameKey;
        this.domainIndices = domainIndices;
    }

    public void map(Chunk[] chunks, NewChunk[] newChunks) {
        int chunkId = chunks[0].cidx();
        if (!LocalNodeDomains.containsDomains(this.frameKey, chunkId)) {
            throw new H2OIllegalArgumentException(String.format("No local domain found for the chunk '%d' on the node '%s'.", chunkId, H2O.SELF.getIpPortString()));
        }
        String[][] localDomains = LocalNodeDomains.getDomains(this.frameKey, chunkId);
        for (int colIdx = 0; colIdx < chunks.length; ++colIdx) {
            int domainIdx = this.domainIndices[colIdx];
            Chunk chunk = chunks[colIdx];
            NewChunk newChunk = newChunks[colIdx];
            String[] localDomain = localDomains[domainIdx];
            for (int valIdx = 0; valIdx < chunk._len; ++valIdx) {
                if (chunk.isNA(valIdx)) {
                    newChunk.addNA();
                    continue;
                }
                int oldValue = (int)chunk.at8(valIdx);
                String category = localDomain[oldValue];
                newChunk.addStr((Object)category);
            }
        }
    }

    public void closeLocal() {
        super.closeLocal();
        LocalNodeDomains.remove(this.frameKey, this.domainIndices);
    }
}

