/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.extensions.internals;

import java.util.ArrayList;
import water.Key;
import water.nbhm.NonBlockingHashMap;

public final class LocalNodeDomains {
    private static NonBlockingHashMap<Key, ArrayList<String[][]>> domainsMap = new NonBlockingHashMap();
    private static NonBlockingHashMap<String, String[][]> domainsMapByChunk = new NonBlockingHashMap();
    private static NonBlockingHashMap<Key, ArrayList<String>> frameKeyToChunkKeys = new NonBlockingHashMap();

    public static synchronized void addDomains(Key frameKey, int chunkId, String[][] domains) {
        ArrayList<String[][]> nodeDomains = (ArrayList<String[][]>)domainsMap.get((Object)frameKey);
        if (nodeDomains == null) {
            nodeDomains = new ArrayList<String[][]>();
            domainsMap.put((Object)frameKey, nodeDomains);
        }
        nodeDomains.add(domains);
        ArrayList<String> chunkKeys = (ArrayList<String>)frameKeyToChunkKeys.get((Object)frameKey);
        if (chunkKeys == null) {
            chunkKeys = new ArrayList<String>();
            frameKeyToChunkKeys.put((Object)frameKey, chunkKeys);
        }
        String chunkKey = LocalNodeDomains.createChunkKey(frameKey, chunkId);
        chunkKeys.add(chunkKey);
        domainsMapByChunk.putIfAbsent((Object)chunkKey, (Object)domains);
    }

    public static synchronized boolean containsDomains(Key frameKey) {
        return domainsMap.containsKey((Object)frameKey);
    }

    public static synchronized boolean containsDomains(Key frameKey, int chunkId) {
        String chunkKey = LocalNodeDomains.createChunkKey(frameKey, chunkId);
        return domainsMapByChunk.containsKey((Object)chunkKey);
    }

    public static synchronized String[][][] getDomains(Key frameKey) {
        return (String[][][])((ArrayList)domainsMap.get((Object)frameKey)).toArray((T[])new String[0][][]);
    }

    public static synchronized String[][] getDomains(Key frameKey, int chunkId) {
        String chunkKey = LocalNodeDomains.createChunkKey(frameKey, chunkId);
        return (String[][])domainsMapByChunk.get((Object)chunkKey);
    }

    public static synchronized void remove(Key frameKey) {
        if (domainsMap.remove((Object)frameKey) != null) {
            ArrayList chunkKeys = (ArrayList)frameKeyToChunkKeys.remove((Object)frameKey);
            for (String chunkKey : chunkKeys) {
                domainsMapByChunk.remove((Object)chunkKey);
            }
            frameKeyToChunkKeys.remove((Object)frameKey);
        }
    }

    public static synchronized void remove(Key frameKey, int[] domainIndices) {
        ArrayList chunkKeys;
        if (domainIndices.length > 0 && (chunkKeys = (ArrayList)frameKeyToChunkKeys.get((Object)frameKey)) != null) {
            ArrayList<String[][]> newFrameDomains = new ArrayList<String[][]>();
            for (int i = 0; i < chunkKeys.size(); ++i) {
                String chunkKey = (String)chunkKeys.get(i);
                String[][] oldDomains = (String[][])domainsMapByChunk.get((Object)chunkKey);
                String[][] newDomains = LocalNodeDomains.removeDomains(oldDomains, domainIndices);
                domainsMapByChunk.replace((Object)chunkKey, (Object)newDomains);
                newFrameDomains.add(newDomains);
            }
            domainsMap.replace((Object)frameKey, newFrameDomains);
        }
    }

    private static String[][] removeDomains(String[][] originalDomains, int[] domainsToRemove) {
        int newSize = originalDomains.length - domainsToRemove.length;
        String[][] result = new String[newSize][];
        int removedDomainIndex = 0;
        for (int originalIndex = 0; originalIndex < originalDomains.length; ++originalIndex) {
            if (removedDomainIndex >= domainsToRemove.length || originalIndex != domainsToRemove[removedDomainIndex]) {
                result[originalIndex - removedDomainIndex] = originalDomains[originalIndex];
                continue;
            }
            ++removedDomainIndex;
        }
        return result;
    }

    private static String createChunkKey(Key frameKey, int chunkId) {
        return frameKey.toString() + "_" + chunkId;
    }
}

