/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.a2a.exceptions;

import ai.koog.a2a.exceptions.A2AAuthenticatedExtendedCardNotConfiguredException;
import ai.koog.a2a.exceptions.A2AContentTypeNotSupportedException;
import ai.koog.a2a.exceptions.A2AException;
import ai.koog.a2a.exceptions.A2AInternalErrorException;
import ai.koog.a2a.exceptions.A2AInvalidAgentResponseException;
import ai.koog.a2a.exceptions.A2AInvalidParamsException;
import ai.koog.a2a.exceptions.A2AInvalidRequestException;
import ai.koog.a2a.exceptions.A2AMethodNotFoundException;
import ai.koog.a2a.exceptions.A2AParseException;
import ai.koog.a2a.exceptions.A2APushNotificationNotSupportedException;
import ai.koog.a2a.exceptions.A2ATaskNotCancelableException;
import ai.koog.a2a.exceptions.A2ATaskNotFoundException;
import ai.koog.a2a.exceptions.A2AUnknownException;
import ai.koog.a2a.exceptions.A2AUnsupportedOperationException;
import ai.koog.a2a.transport.RequestId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"createA2AException", "Lai/koog/a2a/exceptions/A2AException;", "message", "", "errorCode", "", "requestId", "Lai/koog/a2a/transport/RequestId;", "a2a-core"})
public final class ExceptionsKt {
    @NotNull
    public static final A2AException createA2AException(@NotNull String message, int errorCode, @Nullable RequestId requestId) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return switch (errorCode) {
            case -32700 -> new A2AParseException(message, requestId);
            case -32600 -> new A2AInvalidRequestException(message, requestId);
            case -32601 -> new A2AMethodNotFoundException(message, requestId);
            case -32602 -> new A2AInvalidParamsException(message, requestId);
            case -32603 -> new A2AInternalErrorException(message, requestId);
            case -32001 -> new A2ATaskNotFoundException(message, requestId);
            case -32002 -> new A2ATaskNotCancelableException(message, requestId);
            case -32003 -> new A2APushNotificationNotSupportedException(message, requestId);
            case -32004 -> new A2AUnsupportedOperationException(message, requestId);
            case -32005 -> new A2AContentTypeNotSupportedException(message, requestId);
            case -32006 -> new A2AInvalidAgentResponseException(message, requestId);
            case -32007 -> new A2AAuthenticatedExtendedCardNotConfiguredException(message, requestId);
            default -> new A2AUnknownException(message, errorCode, requestId);
        };
    }
}

