package berlin.yuna.tinkerforgesensor.model;

import berlin.yuna.tinkerforgesensor.model.helper.IsType;
import berlin.yuna.tinkerforgesensor.model.helper.ContainsType;

import static java.util.Arrays.stream;

public enum ValueType {
    ALL(null),
    DUMMY(ALL),
    PING(ALL),

    DEVICE_STATUS(ALL),
    DEVICE_CONNECTED(DEVICE_STATUS),
    DEVICE_RECONNECTED(DEVICE_STATUS),
    DEVICE_DISCONNECTED(DEVICE_STATUS),
    DEVICE_TIMEOUT(DEVICE_STATUS),
    DEVICE_UNKNOWN(DEVICE_STATUS),
    EMERGENCY_SHUTDOWN(DEVICE_STATUS),
    DEVICE_SEARCH(DEVICE_STATUS),
    DEVICE_ALREADY_CONNECTED(DEVICE_STATUS),

    ENVIRONMENT(ALL),
    AIR_PRESSURE(ENVIRONMENT),
    IAQ_INDEX(ENVIRONMENT),
    HUMIDITY(ENVIRONMENT),
    TEMPERATURE(ENVIRONMENT),
    ALTITUDE(ENVIRONMENT),
    TILT(ENVIRONMENT),
    MOTION_DETECTED(ENVIRONMENT),

    DISTANCE(ALL),

    SOUND(ALL),
    SOUND_SPECTRUM(SOUND),
    SOUND_INTENSITY(SOUND),
    SOUND_DECIBEL(SOUND),

    BEEP(SOUND),
    BEEP_ACTIVE(BEEP),
    BEEP_FINISH(BEEP),

    LIGHT(ALL),
    LIGHT_UV(LIGHT),
    LIGHT_UVA(LIGHT),
    LIGHT_UVB(LIGHT),
    LIGHT_LUX(LIGHT),

    COLOR(ALL),
    COLOR_R(COLOR),
    COLOR_G(COLOR),
    COLOR_B(COLOR),
    COLOR_C(COLOR),
    COLOR_RGB(COLOR),
    COLOR_LUX(COLOR),
    COLOR_TEMPERATURE(COLOR),

    ORIENTATION(ALL),
    CALIBRATION(ORIENTATION),
    ORIENTATION_HEADING(ORIENTATION),
    ORIENTATION_ROLL(ORIENTATION),
    ORIENTATION_PITCH(ORIENTATION),

    ACCELERATION(ALL),
    ACCELERATION_X(ACCELERATION),
    ACCELERATION_Y(ACCELERATION),
    ACCELERATION_Z(ACCELERATION),
    LINEAR_ACCELERATION_X(ACCELERATION),
    LINEAR_ACCELERATION_Y(ACCELERATION),
    LINEAR_ACCELERATION_Z(ACCELERATION),

    MAGNET(ALL),
    MAGNET_DENSITY(ALL),
    MAGNET_COUNTER(ALL),

    MAGNET_HEADING(MAGNET),
    MAGNETIC_X(ACCELERATION_X),
    MAGNETIC_Y(ACCELERATION_Y),
    MAGNETIC_Z(ACCELERATION_Z),

    ANGULAR_VELOCITY(ALL),
    ANGULAR_VELOCITY_X(ANGULAR_VELOCITY),
    ANGULAR_VELOCITY_Y(ANGULAR_VELOCITY),
    ANGULAR_VELOCITY_Z(ANGULAR_VELOCITY),

    EULER_ANGLE(ALL),
    EULER_ANGLE_X(EULER_ANGLE),
    EULER_ANGLE_Y(EULER_ANGLE),
    EULER_ANGLE_Z(EULER_ANGLE),

    QUATERNION(ALL),
    QUATERNION_W(QUATERNION),
    QUATERNION_X(QUATERNION),
    QUATERNION_Y(QUATERNION),
    QUATERNION_Z(QUATERNION),


    GRAVITY(ALL),
    GRAVITY_VECTOR_X(GRAVITY),
    GRAVITY_VECTOR_Y(GRAVITY),
    GRAVITY_VECTOR_Z(GRAVITY),

    POWER(ALL),

    ENERGY(ALL),
    VOLTAGE_USB(ENERGY),
    VOLTAGE(ENERGY),
    UNDER_VOLTAGE(ENERGY),
    CURRENT(ENERGY),

    BUTTON(ALL),
    BUTTON_TOUCH(ALL),
    BUTTON_PRESSED(BUTTON),
    BUTTON_RELEASED(BUTTON),
    ROTARY(BUTTON),
    PERCENTAGE(BUTTON),

    MOTOR(ALL),
    MOTOR_POSITION(MOTOR),
    MOTOR_VELOCITY(MOTOR),

    HUMAN_INPUT(ALL),
    KEY_INPUT(HUMAN_INPUT),
    KEY_PRESSED(KEY_INPUT),
    KEY_RELEASED(KEY_INPUT),
    KEY_CHAR(KEY_INPUT),

    CURSOR_INPUT(HUMAN_INPUT),
    CURSOR_CLICK_COUNT(CURSOR_INPUT),
    CURSOR_PRESSED(CURSOR_INPUT),
    CURSOR_RELEASED(CURSOR_INPUT),
    CURSOR_ENTERED(CURSOR_INPUT),
    CURSOR_EXITED(CURSOR_INPUT),
    CURSOR_DRAGGED(CURSOR_INPUT),
    CURSOR_MOVED(CURSOR_INPUT),
    CURSOR_MOVE_X(CURSOR_INPUT),
    CURSOR_MOVE_Y(CURSOR_INPUT),
    CURSOR_WHEEL_MOVED(CURSOR_INPUT);

    public final ValueType parent;

    ValueType(final ValueType parent) {
        this.parent = parent;
    }

    public ValueType getParent() {
        return parent;
    }

    public ContainsType contains() {
        return new ContainsType(this);
    }

    public boolean contains(final ValueType... types) {
        return stream(types).anyMatch(type -> type.is(type) || type.parent.contains(types));
    }

    public IsType is() {
        return new IsType(this);
    }

    public boolean is(final ValueType... types) {
        return stream(types).anyMatch(type -> this == type);
    }
}
