/*
 * Decompiled with CFR 0.152.
 */
package co.omise;

import co.omise.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;

public abstract class Endpoint {
    public static final Endpoint VAULT = new Endpoint(){

        @Override
        public String host() {
            return "vault.omise.co";
        }

        @Override
        public String authenticationKey(Config config) {
            return config.publicKey();
        }
    };
    public static final Endpoint API = new Endpoint(){

        @Override
        public String host() {
            return "api.omise.co";
        }

        @Override
        public String authenticationKey(Config config) {
            return config.secretKey();
        }
    };
    public static final String API_VERSION = "2019-05-29";

    public static List<Endpoint> getAllEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.add(VAULT);
        endpoints.add(API);
        return Collections.unmodifiableList(endpoints);
    }

    public static Map<String, Endpoint> getAllEndpointsByHost() {
        HashMap<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
        endpoints.put(VAULT.host(), VAULT);
        endpoints.put(API.host(), API);
        return Collections.unmodifiableMap(endpoints);
    }

    public String scheme() {
        return "https";
    }

    public abstract String host();

    public abstract String authenticationKey(Config var1);

    public HttpUrl.Builder buildUrl() {
        return new HttpUrl.Builder().scheme(this.scheme()).host(this.host());
    }
}

