/*
 * Decompiled with CFR 0.152.
 */
package co.omise;

import co.omise.models.OmiseList;
import co.omise.models.OmiseObject;
import co.omise.models.Params;
import co.omise.requests.RequestBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.fasterxml.jackson.datatype.joda.ser.LocalDateSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Serializer {
    private static Serializer defaultInstance;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeNoMillis();
    private final DateTimeFormatter localDateFormatter = ISODateTimeFormat.date();

    public static Serializer defaultSerializer() {
        if (defaultInstance == null) {
            defaultInstance = new Serializer();
        }
        return defaultInstance;
    }

    private Serializer() {
        this.objectMapper = new ObjectMapper().registerModule((Module)new JodaModule().addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer().withFormat(new JacksonJodaDateFormat(this.dateTimeFormatter), 0)).addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer().withFormat(new JacksonJodaDateFormat(this.localDateFormatter), 0))).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public DateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public DateTimeFormatter localDateFormatter() {
        return this.localDateFormatter;
    }

    public <T extends OmiseObject> T deserialize(InputStream input, Class<T> klass) throws IOException {
        return (T)((OmiseObject)this.objectMapper.readerFor(klass).readValue(input));
    }

    public <T extends OmiseObject> T deserialize(InputStream input, TypeReference<T> ref) throws IOException {
        return (T)((OmiseObject)this.objectMapper.readerFor(ref).readValue(input));
    }

    public <T extends OmiseObject> T deserializeFromMap(Map<String, Object> map, Class<T> klass) {
        return (T)((OmiseObject)this.objectMapper.convertValue(map, klass));
    }

    public <T extends OmiseObject> T deserializeFromMap(Map<String, Object> map, TypeReference<T> ref) {
        return (T)((OmiseObject)this.objectMapper.convertValue(map, ref));
    }

    public <T extends OmiseObject> void serialize(OutputStream output, T model) throws IOException {
        this.objectMapper.writerFor(model.getClass()).writeValue(output, model);
    }

    public <T extends Params> void serializeParams(OutputStream output, T param) throws IOException {
        this.objectMapper.writerFor(param.getClass()).writeValue(output, param);
    }

    public <T extends OmiseObject> Map<String, Object> serializeToMap(T model) {
        return (Map)this.objectMapper.convertValue(model, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public <T extends Enum<T>> String serializeToQueryParams(T value) {
        return (String)this.objectMapper.convertValue(value, String.class);
    }

    public <T extends OmiseList> T deserializeList(InputStream input, TypeReference<T> ref) throws IOException {
        return (T)((OmiseList)this.objectMapper.readerFor(ref).readValue(input));
    }

    public <T extends RequestBuilder> void serializeRequestBuilder(OutputStream outputStream, T builder) throws IOException {
        this.objectMapper.writerFor(builder.getClass()).writeValue(outputStream, builder);
    }
}

