/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models;

import co.omise.Endpoint;
import co.omise.models.Model;
import co.omise.models.ScopedList;
import co.omise.requests.RequestBuilder;
import co.omise.requests.ResponseType;
import com.fasterxml.jackson.core.type.TypeReference;
import okhttp3.HttpUrl;

public class Chain
extends Model {
    private String email;
    private String key;
    private String location;
    private boolean revoked;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public static class RevokeRequestBuilder
    extends RequestBuilder<Chain> {
        private String chainId;

        public RevokeRequestBuilder(String chainId) {
            this.chainId = chainId;
        }

        @Override
        protected String method() {
            return "POST";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "chains", this.chainId, "revoke");
        }

        @Override
        protected ResponseType<Chain> type() {
            return new ResponseType<Chain>(Chain.class);
        }
    }

    public static class GetRequestBuilder
    extends RequestBuilder<Chain> {
        private String chainId;

        public GetRequestBuilder(String chainId) {
            this.chainId = chainId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "chains", this.chainId);
        }

        @Override
        protected ResponseType<Chain> type() {
            return new ResponseType<Chain>(Chain.class);
        }
    }

    public static class ListRequestBuilder
    extends RequestBuilder<ScopedList<Chain>> {
        private ScopedList.Options options;

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(Endpoint.API, "chains", this.serializer()).segments(new String[0]).params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Chain>> type() {
            return new ResponseType<ScopedList<Chain>>(new TypeReference<ScopedList<Chain>>(){});
        }

        public ListRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }
}

