/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models;

import co.omise.Endpoint;
import co.omise.models.Card;
import co.omise.models.Model;
import co.omise.models.ScopedList;
import co.omise.models.schedules.Schedule;
import co.omise.requests.RequestBuilder;
import co.omise.requests.ResponseType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;

public class Customer
extends Model {
    private ScopedList<Card> cards;
    @JsonProperty(value="default_card")
    private String defaultCard;
    private String description;
    private String email;
    private String location;
    private Map<String, Object> metadata;

    public ScopedList<Card> getCards() {
        return this.cards;
    }

    public void setCards(ScopedList<Card> cards) {
        this.cards = cards;
    }

    public String getDefaultCard() {
        return this.defaultCard;
    }

    public void setDefaultCard(String defaultCard) {
        this.defaultCard = defaultCard;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public static class ListSchedulesRequestBuilder
    extends RequestBuilder<ScopedList<Schedule>> {
        private String customerId;
        private ScopedList.Options options;

        public ListSchedulesRequestBuilder(String customerId) {
            this.customerId = customerId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(Endpoint.API, "customers", this.serializer()).segments(this.customerId, "schedules").params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Schedule>> type() {
            return new ResponseType<ScopedList<Schedule>>(new TypeReference<ScopedList<Schedule>>(){});
        }

        public ListSchedulesRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    public static class CreateRequestBuilder
    extends RequestBuilder<Customer> {
        @JsonProperty
        private String card;
        @JsonProperty
        private String description;
        @JsonProperty
        private String email;
        @JsonProperty
        private Map<String, Object> metadata;

        @Override
        protected String method() {
            return "POST";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "customers", new String[0]);
        }

        @Override
        protected ResponseType<Customer> type() {
            return new ResponseType<Customer>(Customer.class);
        }

        public CreateRequestBuilder card(String card) {
            this.card = card;
            return this;
        }

        public CreateRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CreateRequestBuilder email(String email) {
            this.email = email;
            return this;
        }

        public CreateRequestBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        protected RequestBody payload() throws IOException {
            return this.serialize();
        }

        public CreateRequestBuilder metadata(String key, Object value) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            if (this.metadata != null) {
                tempMap.putAll(this.metadata);
            }
            tempMap.put(key, value);
            this.metadata = new HashMap<String, Object>(tempMap);
            return this;
        }
    }

    public static class ListRequestBuilder
    extends RequestBuilder<ScopedList<Customer>> {
        private ScopedList.Options options;

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(Endpoint.API, "customers", this.serializer()).segments(new String[0]).params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Customer>> type() {
            return new ResponseType<ScopedList<Customer>>(new TypeReference<ScopedList<Customer>>(){});
        }

        public ListRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class UpdateRequestBuilder
    extends RequestBuilder<Customer> {
        private String customerId;
        @JsonProperty
        private String card;
        @JsonProperty(value="default_card")
        private String defaultCard;
        @JsonProperty
        private String description;
        @JsonProperty
        private String email;
        @JsonProperty
        private Map<String, Object> metadata;

        public UpdateRequestBuilder(String customerId) {
            this.customerId = customerId;
        }

        @Override
        protected String method() {
            return "PATCH";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "customers", this.customerId);
        }

        @Override
        protected ResponseType<Customer> type() {
            return new ResponseType<Customer>(Customer.class);
        }

        public UpdateRequestBuilder card(String card) {
            this.card = card;
            return this;
        }

        public UpdateRequestBuilder defaultCard(String defaultCard) {
            this.defaultCard = defaultCard;
            return this;
        }

        public UpdateRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public UpdateRequestBuilder email(String email) {
            this.email = email;
            return this;
        }

        public UpdateRequestBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        protected RequestBody payload() throws IOException {
            return this.serialize();
        }

        public UpdateRequestBuilder metadata(String key, Object value) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            if (this.metadata != null) {
                tempMap.putAll(this.metadata);
            }
            tempMap.put(key, value);
            this.metadata = new HashMap<String, Object>(tempMap);
            return this;
        }
    }

    public static class GetRequestBuilder
    extends RequestBuilder<Customer> {
        private String customerId;

        public GetRequestBuilder(String customerId) {
            this.customerId = customerId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "customers", this.customerId);
        }

        @Override
        protected ResponseType<Customer> type() {
            return new ResponseType<Customer>(Customer.class);
        }
    }

    public static class DeleteRequestBuilder
    extends RequestBuilder<Customer> {
        private String customerId;

        public DeleteRequestBuilder(String customerId) {
            this.customerId = customerId;
        }

        @Override
        protected String method() {
            return "DELETE";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "customers", this.customerId);
        }

        @Override
        protected ResponseType<Customer> type() {
            return new ResponseType<Customer>(Customer.class);
        }
    }
}

