/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models;

import co.omise.Endpoint;
import co.omise.models.Model;
import co.omise.models.ScopedList;
import co.omise.requests.RequestBuilder;
import co.omise.requests.ResponseType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;

public class Document
extends Model {
    @JsonProperty(value="download_uri")
    private String downloadUri;
    private String filename;
    private String location;

    public String getDownloadUri() {
        return this.downloadUri;
    }

    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    public static class CreateRequestBuilder
    extends RequestBuilder<Document> {
        private String disputeId;
        @JsonProperty
        private String file;

        public CreateRequestBuilder(String disputeId) {
            this.disputeId = disputeId;
        }

        @Override
        protected String method() {
            return "POST";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "disputes", this.disputeId, "documents");
        }

        @Override
        protected ResponseType<Document> type() {
            return new ResponseType<Document>(Document.class);
        }

        public CreateRequestBuilder file(String file) {
            this.file = file;
            return this;
        }

        @Override
        protected RequestBody payload() throws IOException {
            return this.serialize();
        }
    }

    public static class ListRequestBuilder
    extends RequestBuilder<ScopedList<Document>> {
        private String disputeId;
        private ScopedList.Options options;

        public ListRequestBuilder(String disputeId) {
            this.disputeId = disputeId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(Endpoint.API, "disputes", this.serializer()).segments(this.disputeId, "documents").params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Document>> type() {
            return new ResponseType<ScopedList<Document>>(new TypeReference<ScopedList<Document>>(){});
        }

        public ListRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    public static class GetRequestBuilder
    extends RequestBuilder<Document> {
        private String disputeId;
        private String documentId;

        public GetRequestBuilder(String disputeId, String documentId) {
            this.disputeId = disputeId;
            this.documentId = documentId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "disputes", this.disputeId, "documents", this.documentId);
        }

        @Override
        protected ResponseType<Document> type() {
            return new ResponseType<Document>(Document.class);
        }
    }

    public static class DeleteRequestBuilder
    extends RequestBuilder<Document> {
        private String disputeId;
        private String documentId;

        public DeleteRequestBuilder(String disputeId, String documentId) {
            this.disputeId = disputeId;
            this.documentId = documentId;
        }

        @Override
        protected String method() {
            return "DELETE";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "disputes", this.disputeId, "documents", this.documentId);
        }

        @Override
        protected ResponseType<Document> type() {
            return new ResponseType<Document>(Document.class);
        }
    }
}

