/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models;

import co.omise.Serializer;
import co.omise.models.Model;
import co.omise.models.OmiseList;
import co.omise.models.Ordering;
import co.omise.models.Params;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import okhttp3.RequestBody;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public class ScopedList<T extends Model>
extends OmiseList<T> {
    private DateTime from;
    private DateTime to;
    private int offset;
    private int limit;

    public DateTime getFrom() {
        return this.from;
    }

    public void setFrom(DateTime from) {
        this.from = from;
    }

    public DateTime getTo() {
        return this.to;
    }

    public void setTo(DateTime to) {
        this.to = to;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public static class Options
    extends Params {
        private Integer offset;
        private Integer limit;
        private DateTime from;
        private DateTime to;
        private Ordering order;

        public Options offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Options limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Options from(DateTime from) {
            this.from = from;
            return this;
        }

        public Options to(DateTime to) {
            this.to = to;
            return this;
        }

        public Options order(Ordering order) {
            this.order = order;
            return this;
        }

        @Override
        public Map<String, String> query(Serializer serializer) {
            if (serializer == null) {
                serializer = Serializer.defaultSerializer();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            DateTimeFormatter formatter = serializer.dateTimeFormatter();
            if (this.offset != null) {
                map.put("offset", this.offset.toString());
            }
            if (this.limit != null) {
                map.put("limit", this.limit.toString());
            }
            if (this.from != null) {
                map.put("from", formatter.print((ReadableInstant)this.from));
            }
            if (this.to != null) {
                map.put("to", formatter.print((ReadableInstant)this.to));
            }
            if (this.order != null) {
                map.put("order", serializer.serializeToQueryParams(this.order));
            }
            return Collections.unmodifiableMap(map);
        }

        @Override
        public RequestBody body(Serializer serializer) {
            return null;
        }
    }
}

