/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models;

import co.omise.Endpoint;
import co.omise.Serializer;
import co.omise.models.Model;
import co.omise.models.OmiseList;
import co.omise.models.Ordering;
import co.omise.models.Params;
import co.omise.models.SearchScope;
import co.omise.requests.RequestBuilder;
import co.omise.requests.ResponseType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;

public class SearchResult<T extends Model>
extends OmiseList<T> {
    private SearchScope scope;
    private String query;
    private Map<String, String> filters;
    private int page;
    @JsonProperty(value="total_pages")
    private int totalPages;

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, String> filters) {
        this.filters = filters;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public static class SearchRequestBuilder<T extends Model>
    extends RequestBuilder<SearchResult<T>> {
        private Options options;

        public SearchRequestBuilder(Options options) {
            this.options = options;
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "search", this.options);
        }

        @Override
        protected ResponseType<SearchResult<T>> type() {
            return new ResponseType<SearchResult<T>>(new TypeReference<SearchResult<T>>(){});
        }
    }

    public static class Options
    extends Params {
        private SearchScope scope;
        private String query;
        private Map<String, String> filters;
        private Ordering order;
        private int page;
        private int dataPerPage;

        public Options scope(SearchScope scope) {
            this.scope = scope;
            return this;
        }

        public Options query(String query) {
            this.query = query;
            return this;
        }

        public Options filter(String key, String value) {
            if (this.filters == null) {
                this.filters = new HashMap<String, String>();
                return this.filter(key, value);
            }
            this.filters.put(key, value);
            return this;
        }

        public Options filters(Map<String, String> filters) {
            this.filters = filters;
            return this;
        }

        public Options order(Ordering order) {
            this.order = order;
            return this;
        }

        public Options page(int page) {
            this.page = page;
            return this;
        }

        public Options dataPerPage(int dataPerPage) {
            this.dataPerPage = dataPerPage;
            return this;
        }

        @Override
        public Map<String, String> query(Serializer serializer) {
            if (serializer == null) {
                serializer = Serializer.defaultSerializer();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.scope != null) {
                map.put("scope", serializer.serializeToQueryParams(this.scope));
            }
            if (this.query != null && !this.query.isEmpty()) {
                map.put("query", this.query);
            }
            if (this.filters != null && !this.filters.isEmpty()) {
                for (Map.Entry<String, String> entry : this.filters.entrySet()) {
                    map.put("filters[" + entry.getKey() + "]", entry.getValue());
                }
            }
            if (this.order != null) {
                map.put("order", serializer.serializeToQueryParams(this.order));
            }
            if (this.page > 0) {
                map.put("page", String.valueOf(this.page));
            }
            if (this.dataPerPage > 0) {
                map.put("per_page", String.valueOf(this.dataPerPage));
            }
            return Collections.unmodifiableMap(map);
        }

        @Override
        public RequestBody body(Serializer serializer) {
            return null;
        }
    }
}

