/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models.schedules;

import co.omise.Endpoint;
import co.omise.models.Model;
import co.omise.models.ScopedList;
import co.omise.models.schedules.OccurrenceStatus;
import co.omise.requests.RequestBuilder;
import co.omise.requests.ResponseType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import okhttp3.HttpUrl;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class Occurrence
extends Model {
    private String location;
    private String message;
    @JsonProperty(value="processed_at")
    private DateTime processedAt;
    private String result;
    @JsonProperty(value="retry_on")
    private LocalDate retryOn;
    private String schedule;
    @JsonProperty(value="scheduled_on")
    private LocalDate scheduledOn;
    private OccurrenceStatus status;

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public DateTime getProcessedAt() {
        return this.processedAt;
    }

    public void setProcessedAt(DateTime processedAt) {
        this.processedAt = processedAt;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public LocalDate getRetryOn() {
        return this.retryOn;
    }

    public void setRetryOn(LocalDate retryOn) {
        this.retryOn = retryOn;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public LocalDate getScheduledOn() {
        return this.scheduledOn;
    }

    public void setScheduledOn(LocalDate scheduledOn) {
        this.scheduledOn = scheduledOn;
    }

    public OccurrenceStatus getStatus() {
        return this.status;
    }

    public void setStatus(OccurrenceStatus status) {
        this.status = status;
    }

    public static class ListRequestBuilder
    extends RequestBuilder<ScopedList<Occurrence>> {
        private String scheduleId;
        private ScopedList.Options options;

        public ListRequestBuilder(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            if (this.options == null) {
                this.options = new ScopedList.Options();
            }
            return new RequestBuilder.HttpUrlBuilder(Endpoint.API, "schedules", this.serializer()).segments(this.scheduleId, "occurrences").params(this.options).build();
        }

        @Override
        protected ResponseType<ScopedList<Occurrence>> type() {
            return new ResponseType<ScopedList<Occurrence>>(new TypeReference<ScopedList<Occurrence>>(){});
        }

        public ListRequestBuilder options(ScopedList.Options options) {
            this.options = options;
            return this;
        }
    }

    public static class GetRequestBuilder
    extends RequestBuilder<Occurrence> {
        private String occurrenceId;

        public GetRequestBuilder(String occurrenceId) {
            this.occurrenceId = occurrenceId;
        }

        @Override
        protected String method() {
            return "GET";
        }

        @Override
        protected HttpUrl path() {
            return this.buildUrl(Endpoint.API, "occurrences", this.occurrenceId);
        }

        @Override
        protected ResponseType<Occurrence> type() {
            return new ResponseType<Occurrence>(Occurrence.class);
        }
    }
}

