/*
 * Decompiled with CFR 0.152.
 */
package co.omise.requests;

import co.omise.Serializer;
import co.omise.models.OmiseException;
import co.omise.models.OmiseObjectBase;
import co.omise.requests.Request;
import co.omise.requests.Requester;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;

public class RequesterImpl
implements Requester {
    private OkHttpClient httpClient;
    private Serializer serializer;

    public RequesterImpl(OkHttpClient httpClient, Serializer serializer) {
        this.httpClient = httpClient;
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends OmiseObjectBase, R extends Request<T>> T sendRequest(R request) throws IOException, OmiseException {
        InputStream stream = this.preProcess(this.roundTrip(request.getPath(), request.getPayload(), request.getMethod()));
        if (stream == null) {
            return null;
        }
        try {
            if (request.getType().isClassType()) {
                OmiseObjectBase omiseObjectBase = (OmiseObjectBase)this.serializer.deserialize(stream, request.getType().getClassType());
                return (T)omiseObjectBase;
            }
            OmiseObjectBase omiseObjectBase = (OmiseObjectBase)this.serializer.deserialize(stream, request.getType().getTypeReference());
            return (T)omiseObjectBase;
        }
        finally {
            stream.close();
        }
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    private InputStream preProcess(Response response) throws IOException, OmiseException {
        ResponseBody body = response.body();
        if (body == null) {
            return null;
        }
        InputStream stream = body.byteStream();
        if (200 < response.code()) {
            try {
                OmiseException ex = this.serializer.deserialize(stream, OmiseException.class);
                ex.setHttpStatusCode(response.code());
                throw ex;
            }
            catch (Throwable throwable) {
                stream.close();
                throw throwable;
            }
        }
        return stream;
    }

    private Response roundTrip(HttpUrl url, RequestBody body, String method) throws IOException {
        if (body == null && HttpMethod.requiresRequestBody((String)method)) {
            body = new FormBody.Builder().build();
        }
        okhttp3.Request request = new Request.Builder().method(method, body).url(url).build();
        return this.httpClient.newCall(request).execute();
    }
}

