/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.JobStatus;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.pipeline.Pipeline;
import java.io.IOException;

public class Job
extends JobConf {
    private RunningJob info;

    public Job() {
        this(new JobConf());
    }

    public Job(Configuration conf) {
        super(conf);
    }

    public boolean isComplete() {
        if (this.info == null) {
            return false;
        }
        return this.info.isComplete();
    }

    public boolean isSuccessful() {
        if (this.info == null) {
            return false;
        }
        return this.info.isSuccessful();
    }

    public void killJob() {
        if (this.info == null) {
            return;
        }
        this.info.killJob();
    }

    public Counters getCounters() {
        if (this.info == null) {
            return null;
        }
        return new Counters(this.info.getCounters());
    }

    public void submit() throws OdpsException {
        this.info = JobClient.submitJob(this);
    }

    public boolean run() throws OdpsException {
        return this.waitForCompletion();
    }

    public boolean waitForCompletion() throws OdpsException {
        if (this.info == null) {
            this.submit();
        }
        this.info.waitForCompletion();
        return this.isSuccessful();
    }

    public String getInstanceID() {
        if (this.info == null) {
            return null;
        }
        return this.info.getInstanceID();
    }

    public JobStatus getJobStatus() {
        if (this.info == null) {
            return JobStatus.PREP;
        }
        return this.info.getJobStatus();
    }

    public String getDiagnostics() {
        if (this.info == null) {
            return "";
        }
        return this.info.getDiagnostics();
    }

    public float mapProgress() throws IOException {
        if (this.info == null) {
            return 0.0f;
        }
        return this.info.mapProgress();
    }

    public float reduceProgress() throws IOException {
        if (this.info == null) {
            return 0.0f;
        }
        return this.info.reduceProgress();
    }

    public void addInput(TableInfo table) {
        InputUtils.addTable(table, this);
    }

    public void addOutput(TableInfo table) {
        OutputUtils.addTable(table, this);
    }

    public void setPipeline(Pipeline pipeline) {
        Pipeline.toJobConf(this, pipeline);
    }
}

