/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class LogStore
implements Serializable {
    private static final long serialVersionUID = 7408057477332043832L;
    private String logStoreName = "";
    private int ttl = -1;
    private int shardCount = -1;
    private boolean enableWebTracking = false;
    private int createTime = -1;
    private int lastModifyTime = -1;

    public LogStore() {
    }

    public LogStore(String logStoreName, int ttl, int shardCount) {
        this.logStoreName = logStoreName;
        this.ttl = ttl;
        this.shardCount = shardCount;
    }

    public LogStore(String logStoreName, int ttl, int shardCount, boolean enableWebTracking) {
        this.logStoreName = logStoreName;
        this.ttl = ttl;
        this.shardCount = shardCount;
        this.enableWebTracking = enableWebTracking;
    }

    public LogStore(LogStore logStore) {
        this.logStoreName = logStore.GetLogStoreName();
        this.ttl = logStore.GetTtl();
        this.shardCount = logStore.GetShardCount();
        this.createTime = logStore.GetCreateTime();
        this.lastModifyTime = logStore.GetLastModifyTime();
        this.enableWebTracking = logStore.enableWebTracking;
    }

    public boolean isEnableWebTracking() {
        return this.enableWebTracking;
    }

    public void setEnableWebTracking(boolean enableWebTracking) {
        this.enableWebTracking = enableWebTracking;
    }

    public String GetLogStoreName() {
        return this.logStoreName;
    }

    public int GetTtl() {
        return this.ttl;
    }

    public int GetShardCount() {
        return this.shardCount;
    }

    public int GetCreateTime() {
        return this.createTime;
    }

    public int GetLastModifyTime() {
        return this.lastModifyTime;
    }

    public void SetLogStoreName(String logStoreName) {
        this.logStoreName = logStoreName;
    }

    public void SetTtl(int ttl) {
        this.ttl = ttl;
    }

    public void SetShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public JSONObject ToRequestJson() {
        JSONObject logStoreDict = new JSONObject();
        logStoreDict.put((Object)"logstoreName", (Object)this.GetLogStoreName());
        logStoreDict.put((Object)"ttl", (Object)this.GetTtl());
        logStoreDict.put((Object)"shardCount", (Object)this.GetShardCount());
        logStoreDict.put((Object)"enable_tracking", (Object)this.isEnableWebTracking());
        return logStoreDict;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() {
        JSONObject logStoreDict = this.ToRequestJson();
        logStoreDict.put((Object)"createTime", (Object)this.GetCreateTime());
        logStoreDict.put((Object)"lastModifyTime", (Object)this.GetLastModifyTime());
        return logStoreDict;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.SetLogStoreName(dict.getString("logstoreName"));
            this.SetTtl(dict.getInt("ttl"));
            this.SetShardCount(dict.getInt("shardCount"));
            if (dict.containsKey((Object)"enable_tracking")) {
                this.setEnableWebTracking(dict.getBoolean("enable_tracking"));
            }
            if (dict.containsKey((Object)"createTime")) {
                this.createTime = dict.getInt("createTime");
            }
            if (dict.containsKey((Object)"lastModifyTime")) {
                this.lastModifyTime = dict.getInt("lastModifyTime");
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateLogStore", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String logStoreString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)logStoreString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateLogStore", e.getMessage(), e, "");
        }
    }
}

