/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceDispatcherType;
import com.alibaba.ons.open.trace.core.dispatch.NameServerAddressSetter;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncArrayDispatcher;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.rocketmq.OnsClientRPCHook;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsClientSendMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionExecuter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Properties;

public class TransactionProducerImpl
extends ONSClientAbstract
implements TransactionProducer {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    TransactionMQProducer transactionMQProducer = null;
    private Properties properties;

    public TransactionProducerImpl(Properties properties, TransactionCheckListener transactionCheckListener) {
        super(properties);
        this.properties = properties;
        String producerGroup = properties.getProperty("GROUP_ID", properties.getProperty("ProducerId"));
        if (StringUtils.isEmpty(producerGroup)) {
            producerGroup = "__ONS_PRODUCER_DEFAULT_GROUP";
        }
        this.transactionMQProducer = new TransactionMQProducer(this.getNamespace(), producerGroup, new OnsClientRPCHook(this.provider));
        if (!UtilAll.isBlank(this.namespaceV2)) {
            this.transactionMQProducer.setNamespaceV2(this.namespaceV2);
        }
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.transactionMQProducer.setVipChannelEnabled(isVipChannelEnabled);
        String instanceName = StringUtils.defaultIfEmpty(properties.getProperty("InstanceName"), this.buildIntanceName());
        this.transactionMQProducer.setInstanceName(instanceName);
        boolean addExtendUniqInfo = Boolean.parseBoolean(properties.getProperty("exactlyOnceDelivery", "false"));
        this.transactionMQProducer.setAddExtendUniqInfo(addExtendUniqInfo);
        this.transactionMQProducer.setTransactionCheckListener(transactionCheckListener);
        String msgTraceSwitch = properties.getProperty("MsgTraceSwitch");
        if (!UtilAll.isBlank(msgTraceSwitch) && !Boolean.parseBoolean(msgTraceSwitch)) {
            LOGGER.info("MQ Client Disable the Trace Hook!");
        } else {
            try {
                Properties tempProperties = new Properties();
                tempProperties.put("AccessKey", this.sessionCredentials.getAccessKey());
                tempProperties.put("SecretKey", this.sessionCredentials.getSecretKey());
                tempProperties.put("MaxMsgSize", "128000");
                tempProperties.put("AsyncBufferSize", "2048");
                tempProperties.put("MaxBatchNum", "100");
                String traceInstanceName = UtilAll.getPid() + "_CLIENT_INNER_TRACE_PRODUCER";
                tempProperties.put("InstanceName", traceInstanceName);
                tempProperties.put("DispatcherType", OnsTraceDispatcherType.PRODUCER.name());
                String selectQueueEnableStr = properties.getProperty("MsgTraceSelectQueueEnable", "true");
                tempProperties.put("MsgTraceSelectQueueEnable", selectQueueEnableStr);
                if (!UtilAll.isBlank(this.namespaceV2)) {
                    tempProperties.put("namespace", this.namespaceV2);
                }
                AsyncArrayDispatcher dispatcher = new AsyncArrayDispatcher(tempProperties, this.provider, new NameServerAddressSetter(){

                    @Override
                    public String getNewNameServerAddress() {
                        return TransactionProducerImpl.this.getNameServerAddr();
                    }
                });
                dispatcher.setHostProducer(this.transactionMQProducer.getDefaultMQProducerImpl());
                this.traceDispatcher = dispatcher;
                this.transactionMQProducer.getDefaultMQProducerImpl().registerSendMessageHook(new OnsClientSendMessageHookImpl(this.traceDispatcher));
            }
            catch (Throwable e) {
                LOGGER.error("system mqtrace hook init failed ,maybe can't send msg trace data", e);
            }
        }
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            if (this.transactionMQProducer.getTransactionCheckListener() == null) {
                throw new IllegalArgumentException("TransactionCheckListener is null");
            }
            this.transactionMQProducer.setNamesrvAddr(this.nameServerAddr);
            try {
                this.transactionMQProducer.start();
                super.start();
            }
            catch (MQClientException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void updateNameServerAddr(String newAddrs) {
        this.transactionMQProducer.setNamesrvAddr(newAddrs);
        this.transactionMQProducer.getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().updateNameServerAddressList(newAddrs);
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.transactionMQProducer.shutdown();
        }
        super.shutdown();
    }

    @Override
    public SendResult send(final Message message, final com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter executer, Object arg) {
        this.checkONSProducerServiceState(this.transactionMQProducer.getDefaultMQProducerImpl());
        com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        TransactionSendResult sendResultRMQ = null;
        try {
            sendResultRMQ = this.transactionMQProducer.sendMessageInTransaction(msgRMQ, new LocalTransactionExecuter(){

                @Override
                public LocalTransactionState executeLocalTransactionBranch(com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message msg, Object arg) {
                    String msgId = msg.getProperty("UNIQ_KEY");
                    message.setMsgID(msgId);
                    TransactionStatus transactionStatus = executer.execute(message, arg);
                    if (TransactionStatus.CommitTransaction == transactionStatus) {
                        return LocalTransactionState.COMMIT_MESSAGE;
                    }
                    if (TransactionStatus.RollbackTransaction == transactionStatus) {
                        return LocalTransactionState.ROLLBACK_MESSAGE;
                    }
                    return LocalTransactionState.UNKNOW;
                }
            }, arg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (sendResultRMQ.getLocalTransactionState() == LocalTransactionState.ROLLBACK_MESSAGE) {
            throw new RuntimeException("local transaction branch failed ,so transaction rollback");
        }
        SendResult sendResult = new SendResult();
        sendResult.setMessageId(sendResultRMQ.getMsgId());
        sendResult.setTopic(sendResultRMQ.getMessageQueue().getTopic());
        return sendResult;
    }
}

