/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.common.ThreadLocalIndex;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.LatencyFaultTolerance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.Resolver;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.ServiceDetector;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LatencyFaultToleranceImpl
implements LatencyFaultTolerance<String> {
    private static final InternalLogger log = ClientLogger.getLog();
    private final ConcurrentHashMap<String, FaultItem> faultItemTable = new ConcurrentHashMap(16);
    private int detectTimeout = 200;
    private int detectInterval = 2000;
    private final ThreadLocalIndex whichItemWorst = new ThreadLocalIndex();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "LatencyFaultToleranceScheduledThread");
        }
    });
    private final Resolver resolver;
    private final ServiceDetector serviceDetector;

    public LatencyFaultToleranceImpl(Resolver resolver, ServiceDetector serviceDetector) {
        this.resolver = resolver;
        this.serviceDetector = serviceDetector;
    }

    @Override
    public void detectByOneRound() {
        for (Map.Entry<String, FaultItem> item : this.faultItemTable.entrySet()) {
            boolean serviceOK;
            FaultItem brokerItem = item.getValue();
            if (System.currentTimeMillis() - brokerItem.checkStamp < 0L) continue;
            brokerItem.checkStamp = System.currentTimeMillis() + (long)this.detectInterval;
            String brokerAddr = this.resolver.resolve(brokerItem.getName());
            if (brokerAddr == null) {
                this.faultItemTable.remove(item.getKey());
                continue;
            }
            if (null == this.serviceDetector || !(serviceOK = this.serviceDetector.detect(brokerAddr, this.detectTimeout)) || brokerItem.reachableFlag) continue;
            log.info(brokerItem.name + " is reachable now, then it can be used.");
            brokerItem.reachableFlag = true;
        }
    }

    @Override
    public void startDetector() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    LatencyFaultToleranceImpl.this.detectByOneRound();
                }
                catch (Exception e) {
                    log.warn("Unexpected exception raised while detecting service reachability", e);
                }
            }
        }, 3L, 3L, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public void updateFaultItem(String name, long currentLatency, long notAvailableDuration, boolean reachable) {
        FaultItem old = this.faultItemTable.get(name);
        if (null == old) {
            FaultItem faultItem = new FaultItem(name);
            faultItem.setCurrentLatency(currentLatency);
            faultItem.updateNotAvailableDuration(notAvailableDuration);
            faultItem.setReachable(reachable);
            old = this.faultItemTable.putIfAbsent(name, faultItem);
        }
        if (null != old) {
            old.setCurrentLatency(currentLatency);
            old.updateNotAvailableDuration(notAvailableDuration);
            old.setReachable(reachable);
        }
        if (!reachable) {
            log.info(name + " is unreachable, it will not be used until it's reachable");
        }
    }

    @Override
    public boolean isAvailable(String name) {
        FaultItem faultItem = this.faultItemTable.get(name);
        if (faultItem != null) {
            return faultItem.isAvailable();
        }
        return true;
    }

    @Override
    public boolean isReachable(String name) {
        FaultItem faultItem = this.faultItemTable.get(name);
        if (faultItem != null) {
            return faultItem.isReachable();
        }
        return true;
    }

    @Override
    public void remove(String name) {
        this.faultItemTable.remove(name);
    }

    @Override
    public String pickOneAtLeast() {
        Enumeration<FaultItem> elements = this.faultItemTable.elements();
        LinkedList<FaultItem> tmpList = new LinkedList<FaultItem>();
        while (elements.hasMoreElements()) {
            FaultItem faultItem = elements.nextElement();
            tmpList.add(faultItem);
        }
        if (!tmpList.isEmpty()) {
            Collections.shuffle(tmpList);
            for (FaultItem faultItem : tmpList) {
                if (!faultItem.reachableFlag) continue;
                return faultItem.name;
            }
        }
        return null;
    }

    public String toString() {
        return "LatencyFaultToleranceImpl{faultItemTable=" + this.faultItemTable + ", whichItemWorst=" + this.whichItemWorst + '}';
    }

    @Override
    public void setDetectTimeout(int detectTimeout) {
        this.detectTimeout = detectTimeout;
    }

    @Override
    public void setDetectInterval(int detectInterval) {
        this.detectInterval = detectInterval;
    }

    public class FaultItem
    implements Comparable<FaultItem> {
        private final String name;
        private volatile long currentLatency;
        private volatile long startTimestamp;
        private volatile long checkStamp;
        private volatile boolean reachableFlag;

        public FaultItem(String name) {
            this.name = name;
        }

        public void updateNotAvailableDuration(long notAvailableDuration) {
            if (notAvailableDuration > 0L && System.currentTimeMillis() + notAvailableDuration > this.startTimestamp) {
                this.startTimestamp = System.currentTimeMillis() + notAvailableDuration;
                log.info(this.name + " will be isolated for " + notAvailableDuration + " ms.");
            }
        }

        @Override
        public int compareTo(FaultItem other) {
            if (this.isAvailable() != other.isAvailable()) {
                if (this.isAvailable()) {
                    return -1;
                }
                if (other.isAvailable()) {
                    return 1;
                }
            }
            if (this.currentLatency < other.currentLatency) {
                return -1;
            }
            if (this.currentLatency > other.currentLatency) {
                return 1;
            }
            if (this.startTimestamp < other.startTimestamp) {
                return -1;
            }
            if (this.startTimestamp > other.startTimestamp) {
                return 1;
            }
            return 0;
        }

        public void setReachable(boolean reachableFlag) {
            this.reachableFlag = reachableFlag;
        }

        public void setCheckStamp(long checkStamp) {
            this.checkStamp = checkStamp;
        }

        public boolean isAvailable() {
            return this.reachableFlag && System.currentTimeMillis() >= this.startTimestamp;
        }

        public boolean isReachable() {
            return this.reachableFlag;
        }

        public int hashCode() {
            int result = this.getName() != null ? this.getName().hashCode() : 0;
            result = 31 * result + (int)(this.getCurrentLatency() ^ this.getCurrentLatency() >>> 32);
            result = 31 * result + (int)(this.getStartTimestamp() ^ this.getStartTimestamp() >>> 32);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FaultItem)) {
                return false;
            }
            FaultItem faultItem = (FaultItem)o;
            if (this.getCurrentLatency() != faultItem.getCurrentLatency()) {
                return false;
            }
            if (this.getStartTimestamp() != faultItem.getStartTimestamp()) {
                return false;
            }
            return this.getName() != null ? this.getName().equals(faultItem.getName()) : faultItem.getName() == null;
        }

        public String toString() {
            return "FaultItem{name='" + this.name + '\'' + ", currentLatency=" + this.currentLatency + ", startTimestamp=" + this.startTimestamp + '}';
        }

        public String getName() {
            return this.name;
        }

        public long getCurrentLatency() {
            return this.currentLatency;
        }

        public void setCurrentLatency(long currentLatency) {
            this.currentLatency = currentLatency;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public void setStartTimestamp(long startTimestamp) {
            this.startTimestamp = startTimestamp;
        }
    }
}

