/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryPlan;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryStrategy;
import com.aliyun.openservices.shade.com.google.common.base.Preconditions;
import java.util.concurrent.ThreadLocalRandom;

public class DefaultConsumerRetryStrategy
implements RetryStrategy {
    private static final int MAX_ATTEMPTS_NUM = 5;
    private long timeoutMillis;
    private int maxAttempts;
    private long initialBackoffMillis;
    private long maxBackoffMillis;
    private double backoffMultiplier;
    private long nextBackoffIntervalMillis;
    private volatile int attempts = 0;
    private volatile long deadline = 0L;

    public DefaultConsumerRetryStrategy() {
        this(3000L, 4, 200L, 1000L, 2.0);
    }

    public DefaultConsumerRetryStrategy(long timeoutMillis, int maxAttempts) {
        this(timeoutMillis, maxAttempts, 200L, 1000L, 2.0);
    }

    public DefaultConsumerRetryStrategy(long timeoutMillis, int maxAttempts, long initialBackoffMillis, long maxBackoffMillis, double backoffMultiplier) {
        Preconditions.checkArgument(timeoutMillis > 0L);
        Preconditions.checkArgument(maxAttempts > 1);
        Preconditions.checkArgument(initialBackoffMillis > 0L);
        Preconditions.checkArgument(maxBackoffMillis > 0L);
        Preconditions.checkArgument(backoffMultiplier > 0.0);
        this.timeoutMillis = timeoutMillis;
        this.maxAttempts = maxAttempts >= 5 ? 5 : maxAttempts;
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.backoffMultiplier = backoffMultiplier;
        this.nextBackoffIntervalMillis = initialBackoffMillis;
        this.deadline = System.currentTimeMillis() + this.timeoutMillis;
    }

    @Override
    public RetryStrategy clone() {
        return new DefaultConsumerRetryStrategy(this.timeoutMillis, this.maxAttempts, this.initialBackoffMillis, this.maxBackoffMillis, this.backoffMultiplier);
    }

    @Override
    public int getRetries() {
        return this.attempts;
    }

    @Override
    public RetryPlan makeRetryDecision(int requestCode, Throwable ex) {
        long backoffMillis = 0L;
        long now = System.currentTimeMillis();
        int expire = (int)(this.deadline - now);
        if (expire < 0) {
            return new RetryPlan(false, 0L);
        }
        if (this.maxAttempts > this.attempts + 1) {
            backoffMillis = Math.min(this.nextBackoffIntervalMillis / 2L + (long)ThreadLocalRandom.current().nextInt((int)this.nextBackoffIntervalMillis), (long)expire);
            this.nextBackoffIntervalMillis = Math.min((long)((double)this.nextBackoffIntervalMillis * this.backoffMultiplier), this.maxBackoffMillis);
        } else {
            backoffMillis = this.maxBackoffMillis;
        }
        ++this.attempts;
        return new RetryPlan(true, backoffMillis);
    }

    @Override
    public RetryPlan makeRetryDecision(Throwable ex) {
        return this.makeRetryDecision(1, ex);
    }
}

