/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageConst;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Message
implements Serializable {
    private static final long serialVersionUID = 8445773977080406428L;
    private String topic;
    private int flag;
    private Map<String, String> properties;
    private byte[] body;

    public Message() {
    }

    public Message(String topic, byte[] body) {
        this(topic, "", "", 0, body, true);
    }

    public Message(String topic, String tags, String keys, int flag, byte[] body, boolean waitStoreMsgOK) {
        this.topic = topic;
        this.flag = flag;
        this.body = body;
        if (tags != null && tags.length() > 0) {
            this.setTags(tags);
        }
        if (keys != null && keys.length() > 0) {
            this.setKeys(keys);
        }
        this.setWaitStoreMsgOK(waitStoreMsgOK);
    }

    public Message(String topic, String tags, byte[] body) {
        this(topic, tags, "", 0, body, true);
    }

    public Message(String topic, String tags, String keys, byte[] body) {
        this(topic, tags, keys, 0, body, true);
    }

    public void setKeys(String keys) {
        this.putProperty("KEYS", keys);
    }

    void putProperty(String name, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    public void clearProperty(String name) {
        if (null != this.properties) {
            this.properties.remove(name);
        }
    }

    public void putUserProperty(String name, String value) {
        if (MessageConst.STRING_HASH_SET.contains(name)) {
            throw new RuntimeException(String.format("The Property<%s> is used by system, input another please", name));
        }
        if (value == null || value.trim().isEmpty() || name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The name or value of property can not be null or blank string!");
        }
        for (String prefix : MessageConst.PROPERTY_NAME_PREFIX_SET) {
            if (!name.contains(prefix)) continue;
            throw new RuntimeException(String.format("The Property<%s> uses a system prefix.", name));
        }
        this.putProperty(name, value);
    }

    public String getUserProperty(String name) {
        return this.getProperty(name);
    }

    public String getProperty(String name) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties.get(name);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTags() {
        return this.getProperty("TAGS");
    }

    public void setTags(String tags) {
        String resolveTags = tags;
        if (tags != null) {
            Object[] split = tags.split("\\|\\|");
            for (int i = 0; i < split.length; ++i) {
                split[i] = ((String)split[i]).trim();
            }
            resolveTags = StringUtils.join(split, "||");
        }
        this.putProperty("TAGS", resolveTags);
    }

    public String getKeys() {
        return this.getProperty("KEYS");
    }

    public void setKeys(Collection<String> keys) {
        StringBuffer sb = new StringBuffer();
        for (String k : keys) {
            sb.append(k);
            sb.append(" ");
        }
        this.setKeys(sb.toString().trim());
    }

    public int getDelayTimeLevel() {
        String t = this.getProperty("DELAY");
        if (t != null) {
            return Integer.parseInt(t);
        }
        return 0;
    }

    public void setDelayTimeLevel(int level) {
        this.putProperty("DELAY", String.valueOf(level));
    }

    public boolean isWaitStoreMsgOK() {
        String result = this.getProperty("WAIT");
        if (null == result) {
            return true;
        }
        return Boolean.parseBoolean(result);
    }

    public void setInstanceId(String instanceId) {
        this.putProperty("INSTANCE_ID", instanceId);
    }

    public void setWaitStoreMsgOK(boolean waitStoreMsgOK) {
        this.putProperty("WAIT", Boolean.toString(waitStoreMsgOK));
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getBuyerId() {
        return this.getProperty("BUYER_ID");
    }

    public void setBuyerId(String buyerId) {
        this.putProperty("BUYER_ID", buyerId);
    }

    public String toString() {
        return "Message [topic=" + this.topic + ", flag=" + this.flag + ", properties=" + this.properties + ", body=" + (this.body != null ? this.body.length : 0) + "]";
    }
}

