/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;

public class NamespaceUtil {
    public static final char NAMESPACE_SEPARATOR = '%';
    public static final String NAMESPACE_INFO_SEPARATOR = "_";
    public static final String NAMESPACE_INFO_PREFIX = "MQ";
    public static final int RETRY_PREFIX_LENGTH = "%RETRY%".length();
    public static final int DLQ_PREFIX_LENGTH = "%DLQ%".length();

    public static String withNamespace(RemotingCommand request, String resource) {
        return NamespaceUtil.wrapNamespace(NamespaceUtil.getNamespaceFromRequest(request), resource);
    }

    public static String withoutNamespace(String resource) {
        if (StringUtils.isEmpty(resource) || NamespaceUtil.isSystemResource(resource)) {
            return resource;
        }
        if (NamespaceUtil.isRetryTopic(resource)) {
            int index = resource.indexOf(37, RETRY_PREFIX_LENGTH);
            if (index > 0) {
                return MixAll.getRetryTopic(resource.substring(index + 1));
            }
            return resource;
        }
        if (NamespaceUtil.isDLQTopic(resource)) {
            int index = resource.indexOf(37, DLQ_PREFIX_LENGTH);
            if (index > 0) {
                return MixAll.getDLQTopic(resource.substring(index + 1));
            }
            return resource;
        }
        int index = resource.indexOf(37);
        if (index > 0) {
            return resource.substring(index + 1);
        }
        return resource;
    }

    public static String withoutNamespace(String resource, String namespace) {
        if (StringUtils.isEmpty(resource) || StringUtils.isEmpty(namespace)) {
            return resource;
        }
        StringBuffer prefixBuffer = new StringBuffer();
        if (NamespaceUtil.isRetryTopic(resource)) {
            prefixBuffer.append("%RETRY%");
        } else if (NamespaceUtil.isDLQTopic(resource)) {
            prefixBuffer.append("%DLQ%");
        }
        prefixBuffer.append(namespace).append('%');
        if (resource.startsWith(prefixBuffer.toString())) {
            return NamespaceUtil.withoutNamespace(resource);
        }
        return resource;
    }

    public static String wrapNamespace(String namespace, String resource) {
        if (StringUtils.isEmpty(namespace) || StringUtils.isEmpty(resource)) {
            return resource;
        }
        if (NamespaceUtil.isSystemResource(resource)) {
            return resource;
        }
        if (NamespaceUtil.isAlreadyWithNamespace(resource, namespace)) {
            return resource;
        }
        StringBuffer strBuffer = new StringBuffer().append(namespace).append('%');
        if (NamespaceUtil.isRetryTopic(resource)) {
            strBuffer.append(resource.substring(RETRY_PREFIX_LENGTH));
            return strBuffer.insert(0, "%RETRY%").toString();
        }
        if (NamespaceUtil.isDLQTopic(resource)) {
            strBuffer.append(resource.substring(DLQ_PREFIX_LENGTH));
            return strBuffer.insert(0, "%DLQ%").toString();
        }
        return strBuffer.append(resource).toString();
    }

    public static boolean isAlreadyWithNamespace(String resource, String namespace) {
        if (StringUtils.isEmpty(namespace) || StringUtils.isEmpty(resource) || NamespaceUtil.isSystemResource(resource)) {
            return false;
        }
        if (NamespaceUtil.isRetryTopic(resource)) {
            resource = resource.substring(RETRY_PREFIX_LENGTH);
        }
        if (NamespaceUtil.isDLQTopic(resource)) {
            resource = resource.substring(DLQ_PREFIX_LENGTH);
        }
        return resource.startsWith(namespace + '%');
    }

    public static String withNamespaceAndRetry(RemotingCommand request, String consumerGroup) {
        return NamespaceUtil.wrapNamespaceAndRetry(NamespaceUtil.getNamespaceFromRequest(request), consumerGroup);
    }

    public static String wrapNamespaceAndRetry(String namespace, String consumerGroup) {
        if (StringUtils.isEmpty(consumerGroup)) {
            return null;
        }
        return new StringBuffer().append("%RETRY%").append(NamespaceUtil.wrapNamespace(namespace, consumerGroup)).toString();
    }

    public static String getNamespaceFromRequest(RemotingCommand request) {
        String namespace;
        if (null == request || null == request.getExtFields()) {
            return null;
        }
        switch (request.getCode()) {
            case 310: {
                namespace = request.getExtFields().get("n");
                break;
            }
            default: {
                namespace = request.getExtFields().get("namespace");
            }
        }
        return namespace;
    }

    public static String getUidFromNameSpace(String namespace) {
        String[] arr = namespace.split(NAMESPACE_INFO_SEPARATOR);
        if (arr.length != 4 || !arr[0].equals(NAMESPACE_INFO_PREFIX)) {
            return "";
        }
        return arr[1];
    }

    public static String getNamespaceFromResource(String resource) {
        if (StringUtils.isEmpty(resource) || NamespaceUtil.isSystemResource(resource)) {
            return "";
        }
        if (NamespaceUtil.isRetryTopic(resource)) {
            int index = resource.indexOf(37, RETRY_PREFIX_LENGTH);
            if (index > 0) {
                return resource.substring(RETRY_PREFIX_LENGTH, index);
            }
            return "";
        }
        if (NamespaceUtil.isDLQTopic(resource)) {
            int index = resource.indexOf(37, DLQ_PREFIX_LENGTH);
            if (index > 0) {
                return resource.substring(DLQ_PREFIX_LENGTH, index);
            }
            return "";
        }
        int index = resource.indexOf(37);
        if (index > 0) {
            return resource.substring(0, index);
        }
        return "";
    }

    private static boolean isSystemResource(String resource) {
        if (StringUtils.isEmpty(resource)) {
            return false;
        }
        if (MixAll.isSystemTopic(resource)) {
            return true;
        }
        if (MixAll.isSysConsumerGroup(resource)) {
            return true;
        }
        return "TBW102".equals(resource);
    }

    public static boolean isRetryTopic(String resource) {
        if (StringUtils.isEmpty(resource)) {
            return false;
        }
        return resource.startsWith("%RETRY%");
    }

    public static boolean isDLQTopic(String resource) {
        if (StringUtils.isEmpty(resource)) {
            return false;
        }
        return resource.startsWith("%DLQ%");
    }
}

