/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.utils;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.concurrent.atomic.AtomicLong;

public class EclipseCounter {
    private AtomicLong counter = new AtomicLong(0L);
    private AtomicLong eclipse = new AtomicLong(0L);
    private long lastPrintTime = 0L;
    private int printInterval = 10000;
    private final String prefix;
    InternalLogger log;

    public EclipseCounter(int printInterval, String prefix, InternalLogger log) {
        this.printInterval = printInterval;
        this.prefix = prefix;
        this.log = log;
    }

    public void mark(int add, long eclipse) {
        this.mark(add, eclipse, System.currentTimeMillis());
    }

    public void mark(int add, long eclipse, long now) {
        long count = this.counter.addAndGet(add);
        long time = this.eclipse.addAndGet(eclipse);
        if (this.lastPrintTime == 0L && count > 1L || count > 0L && now - this.lastPrintTime > (long)this.printInterval) {
            float avg = (float)time / (float)count;
            avg = avg > 0.001f ? avg : 0.001f;
            this.log.info("[{}]{}Count:{}, {}Time:{}, {}AVG:{}", this.prefix, this.prefix, count, this.prefix, time, this.prefix, Float.valueOf(avg));
            this.counter.set(0L);
            this.eclipse.set(0L);
            this.lastPrintTime = now;
        }
    }
}

