/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.http2proxy;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyServerConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.ProtocolHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.http2proxy.Http2ProxyBackendHandler;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.protocol.http2proxy.Http2ProxyFrontendHandler;
import com.aliyun.openservices.shade.io.netty.bootstrap.Bootstrap;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInitializer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContextBuilder;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslProvider;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;

public class Http2ProtocolProxyHandler
implements ProtocolHandler {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final int PRI_INT = 1347569952;
    private final NettyServerConfig nettyServerConfig;
    private final SslContext sslContext;

    public Http2ProtocolProxyHandler(NettyServerConfig nettyServerConfig) {
        if (nettyServerConfig.isEnableHttp2SslProxy()) {
            try {
                this.sslContext = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, "h2")).build();
            }
            catch (SSLException e) {
                log.error("Failed to create SSLContext for Http2ProtocolProxyHandler", e);
                throw new RuntimeException("Failed to create SSLContext for Http2ProtocolProxyHandler", e);
            }
        } else {
            this.sslContext = null;
        }
        this.nettyServerConfig = nettyServerConfig;
    }

    @Override
    public boolean match(ByteBuf in) {
        if (!this.nettyServerConfig.isEnableHttp2Proxy()) {
            return false;
        }
        return in.getInt(in.readerIndex()) == 1347569952;
    }

    @Override
    public void config(ChannelHandlerContext ctx, final ByteBuf msg) {
        final Channel inboundChannel = ctx.channel();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group(inboundChannel.eventLoop())).channel(ctx.channel().getClass())).handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                if (Http2ProtocolProxyHandler.this.sslContext != null && Http2ProtocolProxyHandler.this.nettyServerConfig.isEnableHttp2SslProxy()) {
                    ch.pipeline().addLast(Http2ProtocolProxyHandler.this.sslContext.newHandler(ch.alloc(), Http2ProtocolProxyHandler.this.nettyServerConfig.getHttp2ProxyHost(), Http2ProtocolProxyHandler.this.nettyServerConfig.getHttp2ProxyPort()));
                }
                ch.pipeline().addLast(new Http2ProxyBackendHandler(inboundChannel));
            }
        })).option(ChannelOption.AUTO_READ, false);
        ChannelFuture f = b.connect(this.nettyServerConfig.getHttp2ProxyHost(), this.nettyServerConfig.getHttp2ProxyPort());
        final Channel outboundChannel = f.channel();
        ctx.pipeline().addLast(new Http2ProxyFrontendHandler(outboundChannel));
        msg.retain();
        f.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    outboundChannel.writeAndFlush(msg);
                    inboundChannel.read();
                } else {
                    inboundChannel.close();
                }
            }
        });
    }
}

