/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.vtoa;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.vtoa.Vtoa;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.socket.DefaultSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public class VpcTunnelUtils {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    public static final String PROPERTY_VTOA_TUNNEL_ID = "VTOA_TUNNEL_ID";
    public static final String PROPERTY_VTOA_CLIENT_ADDR = "VTOA_CLIENT_ADDR";
    public static final String PROPERTY_VTOA_CLIENT_PORT = "VTOA_CLIENT_PORT";
    private static volatile VpcTunnelUtils instance;

    public static native int getvip(int var0, Vtoa var1);

    private VpcTunnelUtils() {
        System.loadLibrary("getvip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VpcTunnelUtils getInstance() {
        if (instance != null) return instance;
        Class<VpcTunnelUtils> clazz = VpcTunnelUtils.class;
        synchronized (VpcTunnelUtils.class) {
            if (instance != null) return instance;
            instance = new VpcTunnelUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Vtoa getVtoa(ChannelHandlerContext ctx) {
        return this.getVtoa(ctx.channel());
    }

    public Vtoa getVtoa(Channel channel) {
        Vtoa vtoa = new Vtoa(-1, -1, -1);
        int result = VpcTunnelUtils.getvip(this.getSocketFd(channel), vtoa);
        if (result == 0) {
            log.debug("Get tunnel_id from vtoa success: resultCode={}, vid={}, vaddr={}, vport={}", result, vtoa.getVid(), vtoa.getVaddr(), vtoa.getVport());
        } else {
            log.debug("Get tunnel_id from vtoa error: resultCode={}, vid={}, vaddr={}, vport={}", result, vtoa.getVid(), vtoa.getVaddr(), vtoa.getVport());
        }
        return vtoa;
    }

    public Vtoa getVtoa(int fd) {
        Vtoa vtoa = new Vtoa(-1, -1, -1);
        int result = VpcTunnelUtils.getvip(fd, vtoa);
        if (result == 0) {
            log.debug("Get tunnel_id from vtoa success: resultCode={}, vid={}, vaddr={}, vport={}", result, vtoa.getVid(), vtoa.getVaddr(), vtoa.getVport());
        } else {
            log.debug("Get tunnel_id from vtoa error: resultCode={}, vid={}, vaddr={}, vport={}", result, vtoa.getVid(), vtoa.getVaddr(), vtoa.getVport());
        }
        return vtoa;
    }

    private int getSocketFd(Channel channel) {
        try {
            if (!(channel instanceof NioSocketChannel)) {
                log.warn("Channel is not instance of NioSocketChannel");
                return 0;
            }
            NioSocketChannel nioChannel = (NioSocketChannel)channel;
            DefaultSocketChannelConfig config = (DefaultSocketChannelConfig)nioChannel.config();
            Field socketField = config.getClass().getSuperclass().getDeclaredField("javaSocket");
            socketField.setAccessible(true);
            Object socketValue = socketField.get(config);
            Socket socket = (Socket)socketValue;
            SocketChannel socketChannel = socket.getChannel();
            Field fdValField = socketChannel.getClass().getDeclaredField("fdVal");
            fdValField.setAccessible(true);
            return fdValField.getInt(socketChannel);
        }
        catch (NoSuchFieldException e) {
            log.error("Get socket field failed. ", e);
        }
        catch (IllegalAccessException e) {
            log.error("Get socket field failed. ", e);
        }
        catch (Exception e) {
            log.error("Get socket field failed. ", e);
        }
        return 0;
    }
}

