/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.HmacSHA1Signature;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class ServiceSignature {
    public abstract String getAlgorithm();

    public abstract String getVersion();

    public abstract String computeSignature(String var1, String var2);

    public static ServiceSignature create() {
        return new HmacSHA1Signature();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sign(byte[] key, byte[] data, Mac macInstance, Object lock, String algorithm) {
        try {
            Mac mac;
            if (macInstance == null) {
                Object object = lock;
                synchronized (object) {
                    if (macInstance == null) {
                        macInstance = Mac.getInstance(algorithm);
                    }
                }
            }
            try {
                mac = (Mac)macInstance.clone();
            }
            catch (CloneNotSupportedException e) {
                mac = Mac.getInstance(algorithm);
            }
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Unsupported algorithm: " + algorithm, ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Invalid key: " + key, ex);
        }
    }
}

