/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.utils;

import com.aliyun.oss.common.auth.PublicKey;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.ram.model.v20150501.DeletePublicKeyRequest;
import com.aliyuncs.ram.model.v20150501.ListPublicKeysRequest;
import com.aliyuncs.ram.model.v20150501.ListPublicKeysResponse;
import com.aliyuncs.ram.model.v20150501.UploadPublicKeyRequest;
import com.aliyuncs.ram.model.v20150501.UploadPublicKeyResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class AuthUtils {
    public static final int DEFAULT_EXPIRED_DURATION_SECONDS = 3600;
    public static final double DEFAULT_EXPIRED_FACTOR = 0.8;
    public static final int MAX_ECS_METADATA_FETCH_RETRY_TIMES = 3;
    public static final int DEFAULT_ECS_SESSION_TOKEN_DURATION_SECONDS = 21600;
    public static final int DEFAULT_STS_SESSION_TOKEN_DURATION_SECONDS = 3600;
    public static final int DEFAULT_HTTP_SOCKET_TIMEOUT_IN_MILLISECONDS = 5000;
    public static final String ACCESS_KEY_ENV_VAR = "OSS_ACCESS_KEY_ID";
    public static final String SECRET_KEY_ENV_VAR = "OSS_ACCESS_KEY_SECRET";
    public static final String SESSION_TOKEN_ENV_VAR = "OSS_SESSION_TOKEN";
    public static final String ACCESS_KEY_SYSTEM_PROPERTY = "oss.accessKeyId";
    public static final String SECRET_KEY_SYSTEM_PROPERTY = "oss.accessKeySecret";
    public static final String SESSION_TOKEN_SYSTEM_PROPERTY = "oss.sessionToken";
    public static final String DEFAULT_PROFILE_PATH = AuthUtils.defaultProfilePath();
    public static final String DEFAULT_SECTION_NAME = "default";
    public static final String OSS_ACCESS_KEY_ID = "oss_access_key_id";
    public static final String OSS_SECRET_ACCESS_KEY = "oss_secret_access_key";
    public static final String OSS_SESSION_TOKEN = "oss_session_token";

    public static String defaultProfilePath() {
        return System.getProperty("user.home") + File.separator + ".oss" + File.separator + "credentials";
    }

    public static PublicKey uploadPublicKey(String regionId, String accessKeyId, String accessKeySecret, String publicKey) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        UploadPublicKeyRequest uploadPublicKeyRequest = new UploadPublicKeyRequest();
        uploadPublicKeyRequest.setPublicKeySpec(publicKey);
        UploadPublicKeyResponse uploadPublicKeyResponse = (UploadPublicKeyResponse)client.getAcsResponse((AcsRequest)uploadPublicKeyRequest);
        UploadPublicKeyResponse.PublicKey pubKey = uploadPublicKeyResponse.getPublicKey();
        return new PublicKey(pubKey);
    }

    public static List<PublicKey> listPublicKeys(String regionId, String accessKeyId, String accessKeySecret) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        ListPublicKeysRequest listPublicKeysRequest = new ListPublicKeysRequest();
        ListPublicKeysResponse listPublicKeysResponse = (ListPublicKeysResponse)client.getAcsResponse((AcsRequest)listPublicKeysRequest);
        ArrayList<PublicKey> publicKeys = new ArrayList<PublicKey>();
        for (ListPublicKeysResponse.PublicKey publicKey : listPublicKeysResponse.getPublicKeys()) {
            publicKeys.add(new PublicKey(publicKey));
        }
        return publicKeys;
    }

    public static void deletePublicKey(String regionId, String accessKeyId, String accessKeySecret, String publicKeyId) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        DeletePublicKeyRequest deletePublicKeyRequest = new DeletePublicKeyRequest();
        deletePublicKeyRequest.setUserPublicKeyId(publicKeyId);
        client.getAcsResponse((AcsRequest)deletePublicKeyRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadPublicKeyFromFile(String publicKeyPath) throws IOException {
        File file = new File(publicKeyPath);
        byte[] filecontent = new byte[(int)file.length()];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ((InputStream)in).read(filecontent);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(filecontent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadPrivateKeyFromFile(String privateKeyPath) throws IOException {
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(privateKeyPath)));
            String str = null;
            while ((str = reader.readLine()) != null) {
                if (str.indexOf("-----BEGIN PRIVATE KEY-----") != -1) continue;
                if (str.indexOf("-----END PRIVATE KEY-----") != -1) {
                    break;
                }
                if (str == null) continue;
                builder.append(str + "\n");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return builder.toString();
    }
}

