/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.util;

public class ExponentialBackoffStrategy {
    private long delayInterval;
    private long initialDelay;
    private long maxDelay;

    public ExponentialBackoffStrategy(long delayInterval, long initialDelay, long maxDelay) {
        this.delayInterval = delayInterval;
        this.initialDelay = initialDelay;
        this.maxDelay = maxDelay;
    }

    public long delayBeforeNextRetry(int retriesAttempted) {
        if (retriesAttempted < 1) {
            return this.initialDelay;
        }
        if (retriesAttempted > 63) {
            return this.maxDelay;
        }
        long multiplier = 1L << retriesAttempted - 1;
        if (multiplier > Long.MAX_VALUE / this.delayInterval) {
            return this.maxDelay;
        }
        long delay = multiplier * this.delayInterval;
        delay = Math.min(delay, this.maxDelay);
        return delay;
    }
}

