/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockruntime.model.GuardrailContentQualifier;
import com.amazonaws.services.bedrockruntime.model.transform.GuardrailTextBlockMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GuardrailTextBlock
implements Serializable,
Cloneable,
StructuredPojo {
    private String text;
    private List<String> qualifiers;

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public GuardrailTextBlock withText(String text) {
        this.setText(text);
        return this;
    }

    public List<String> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(Collection<String> qualifiers) {
        if (qualifiers == null) {
            this.qualifiers = null;
            return;
        }
        this.qualifiers = new ArrayList<String>(qualifiers);
    }

    public GuardrailTextBlock withQualifiers(String ... qualifiers) {
        if (this.qualifiers == null) {
            this.setQualifiers(new ArrayList<String>(qualifiers.length));
        }
        for (String ele : qualifiers) {
            this.qualifiers.add(ele);
        }
        return this;
    }

    public GuardrailTextBlock withQualifiers(Collection<String> qualifiers) {
        this.setQualifiers(qualifiers);
        return this;
    }

    public GuardrailTextBlock withQualifiers(GuardrailContentQualifier ... qualifiers) {
        ArrayList<String> qualifiersCopy = new ArrayList<String>(qualifiers.length);
        for (GuardrailContentQualifier value : qualifiers) {
            qualifiersCopy.add(value.toString());
        }
        if (this.getQualifiers() == null) {
            this.setQualifiers(qualifiersCopy);
        } else {
            this.getQualifiers().addAll(qualifiersCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getQualifiers() != null) {
            sb.append("Qualifiers: ").append(this.getQualifiers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTextBlock)) {
            return false;
        }
        GuardrailTextBlock other = (GuardrailTextBlock)obj;
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getQualifiers() == null ^ this.getQualifiers() == null) {
            return false;
        }
        return other.getQualifiers() == null || other.getQualifiers().equals(this.getQualifiers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getQualifiers() == null ? 0 : this.getQualifiers().hashCode());
        return hashCode;
    }

    public GuardrailTextBlock clone() {
        try {
            return (GuardrailTextBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GuardrailTextBlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

