/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.UserGroup;
import com.amazonaws.services.elasticache.model.transform.UserGroupPendingChangesStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class UserGroupStaxUnmarshaller
implements Unmarshaller<UserGroup, StaxUnmarshallerContext> {
    private static UserGroupStaxUnmarshaller instance;

    public UserGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        UserGroup userGroup = new UserGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return userGroup;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("UserGroupId", targetDepth)) {
                    userGroup.setUserGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    userGroup.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Engine", targetDepth)) {
                    userGroup.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UserIds", targetDepth)) {
                    userGroup.withUserIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("UserIds/member", targetDepth)) {
                    userGroup.withUserIds(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PendingChanges", targetDepth)) {
                    userGroup.setPendingChanges(UserGroupPendingChangesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicationGroups", targetDepth)) {
                    userGroup.withReplicationGroups(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ReplicationGroups/member", targetDepth)) {
                    userGroup.withReplicationGroups(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ARN", targetDepth)) continue;
                userGroup.setARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return userGroup;
    }

    public static UserGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new UserGroupStaxUnmarshaller();
        }
        return instance;
    }
}

