/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.StepStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.StepStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepTimelineJsonMarshaller;

public class StepStatusJsonMarshaller {
    private static StepStatusJsonMarshaller instance;

    public void marshall(StepStatus stepStatus, StructuredJsonGenerator jsonGenerator) {
        if (stepStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (stepStatus.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(stepStatus.getState());
            }
            if (stepStatus.getStateChangeReason() != null) {
                jsonGenerator.writeFieldName("StateChangeReason");
                StepStateChangeReasonJsonMarshaller.getInstance().marshall(stepStatus.getStateChangeReason(), jsonGenerator);
            }
            if (stepStatus.getTimeline() != null) {
                jsonGenerator.writeFieldName("Timeline");
                StepTimelineJsonMarshaller.getInstance().marshall(stepStatus.getTimeline(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepStatusJsonMarshaller();
        }
        return instance;
    }
}

