/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrcontainers.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.emrcontainers.model.EndpointState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ListManagedEndpointsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String virtualClusterId;
    private Date createdBefore;
    private Date createdAfter;
    private List<String> types;
    private List<String> states;
    private Integer maxResults;
    private String nextToken;

    public void setVirtualClusterId(String virtualClusterId) {
        this.virtualClusterId = virtualClusterId;
    }

    public String getVirtualClusterId() {
        return this.virtualClusterId;
    }

    public ListManagedEndpointsRequest withVirtualClusterId(String virtualClusterId) {
        this.setVirtualClusterId(virtualClusterId);
        return this;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public ListManagedEndpointsRequest withCreatedBefore(Date createdBefore) {
        this.setCreatedBefore(createdBefore);
        return this;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public ListManagedEndpointsRequest withCreatedAfter(Date createdAfter) {
        this.setCreatedAfter(createdAfter);
        return this;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<String> types) {
        if (types == null) {
            this.types = null;
            return;
        }
        this.types = new ArrayList<String>(types);
    }

    public ListManagedEndpointsRequest withTypes(String ... types) {
        if (this.types == null) {
            this.setTypes(new ArrayList<String>(types.length));
        }
        for (String ele : types) {
            this.types.add(ele);
        }
        return this;
    }

    public ListManagedEndpointsRequest withTypes(Collection<String> types) {
        this.setTypes(types);
        return this;
    }

    public List<String> getStates() {
        return this.states;
    }

    public void setStates(Collection<String> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<String>(states);
    }

    public ListManagedEndpointsRequest withStates(String ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<String>(states.length));
        }
        for (String ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public ListManagedEndpointsRequest withStates(Collection<String> states) {
        this.setStates(states);
        return this;
    }

    public ListManagedEndpointsRequest withStates(EndpointState ... states) {
        ArrayList<String> statesCopy = new ArrayList<String>(states.length);
        for (EndpointState value : states) {
            statesCopy.add(value.toString());
        }
        if (this.getStates() == null) {
            this.setStates(statesCopy);
        } else {
            this.getStates().addAll(statesCopy);
        }
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListManagedEndpointsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListManagedEndpointsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVirtualClusterId() != null) {
            sb.append("VirtualClusterId: ").append(this.getVirtualClusterId()).append(",");
        }
        if (this.getCreatedBefore() != null) {
            sb.append("CreatedBefore: ").append(this.getCreatedBefore()).append(",");
        }
        if (this.getCreatedAfter() != null) {
            sb.append("CreatedAfter: ").append(this.getCreatedAfter()).append(",");
        }
        if (this.getTypes() != null) {
            sb.append("Types: ").append(this.getTypes()).append(",");
        }
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedEndpointsRequest)) {
            return false;
        }
        ListManagedEndpointsRequest other = (ListManagedEndpointsRequest)obj;
        if (other.getVirtualClusterId() == null ^ this.getVirtualClusterId() == null) {
            return false;
        }
        if (other.getVirtualClusterId() != null && !other.getVirtualClusterId().equals(this.getVirtualClusterId())) {
            return false;
        }
        if (other.getCreatedBefore() == null ^ this.getCreatedBefore() == null) {
            return false;
        }
        if (other.getCreatedBefore() != null && !other.getCreatedBefore().equals(this.getCreatedBefore())) {
            return false;
        }
        if (other.getCreatedAfter() == null ^ this.getCreatedAfter() == null) {
            return false;
        }
        if (other.getCreatedAfter() != null && !other.getCreatedAfter().equals(this.getCreatedAfter())) {
            return false;
        }
        if (other.getTypes() == null ^ this.getTypes() == null) {
            return false;
        }
        if (other.getTypes() != null && !other.getTypes().equals(this.getTypes())) {
            return false;
        }
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        if (other.getStates() != null && !other.getStates().equals(this.getStates())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVirtualClusterId() == null ? 0 : this.getVirtualClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBefore() == null ? 0 : this.getCreatedBefore().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAfter() == null ? 0 : this.getCreatedAfter().hashCode());
        hashCode = 31 * hashCode + (this.getTypes() == null ? 0 : this.getTypes().hashCode());
        hashCode = 31 * hashCode + (this.getStates() == null ? 0 : this.getStates().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListManagedEndpointsRequest clone() {
        return (ListManagedEndpointsRequest)super.clone();
    }
}

