/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateAssessmentTemplateRequestMarshaller
implements Marshaller<Request<CreateAssessmentTemplateRequest>, CreateAssessmentTemplateRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateAssessmentTemplateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateAssessmentTemplateRequest> marshall(CreateAssessmentTemplateRequest createAssessmentTemplateRequest) {
        if (createAssessmentTemplateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAssessmentTemplateRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.CreateAssessmentTemplate");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Attribute> userAttributesForFindingsList;
            List<String> rulesPackageArnsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createAssessmentTemplateRequest.getAssessmentTargetArn() != null) {
                jsonGenerator.writeFieldName("assessmentTargetArn").writeValue(createAssessmentTemplateRequest.getAssessmentTargetArn());
            }
            if (createAssessmentTemplateRequest.getAssessmentTemplateName() != null) {
                jsonGenerator.writeFieldName("assessmentTemplateName").writeValue(createAssessmentTemplateRequest.getAssessmentTemplateName());
            }
            if (createAssessmentTemplateRequest.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue(createAssessmentTemplateRequest.getDurationInSeconds().intValue());
            }
            if ((rulesPackageArnsList = createAssessmentTemplateRequest.getRulesPackageArns()) != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackageArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesForFindingsList = createAssessmentTemplateRequest.getUserAttributesForFindings()) != null) {
                jsonGenerator.writeFieldName("userAttributesForFindings");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

