/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.Resource;

@SdkInternalApi
public class ResourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> CATALOG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Catalog").build();
    private static final MarshallingInfo<StructuredPojo> DATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").build();
    private static final MarshallingInfo<StructuredPojo> TABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<StructuredPojo> TABLEWITHCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableWithColumns").build();
    private static final MarshallingInfo<StructuredPojo> DATALOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataLocation").build();
    private static final MarshallingInfo<StructuredPojo> LFTAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LFTag").build();
    private static final MarshallingInfo<StructuredPojo> LFTAGPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LFTagPolicy").build();
    private static final ResourceMarshaller instance = new ResourceMarshaller();

    public static ResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Resource resource, ProtocolMarshaller protocolMarshaller) {
        if (resource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resource.getCatalog(), CATALOG_BINDING);
            protocolMarshaller.marshall((Object)resource.getDatabase(), DATABASE_BINDING);
            protocolMarshaller.marshall((Object)resource.getTable(), TABLE_BINDING);
            protocolMarshaller.marshall((Object)resource.getTableWithColumns(), TABLEWITHCOLUMNS_BINDING);
            protocolMarshaller.marshall((Object)resource.getDataLocation(), DATALOCATION_BINDING);
            protocolMarshaller.marshall((Object)resource.getLFTag(), LFTAG_BINDING);
            protocolMarshaller.marshall((Object)resource.getLFTagPolicy(), LFTAGPOLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

