/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager;

import javax.annotation.Generated;

import com.amazonaws.services.mailmanager.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSMailManager}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMailManager implements AWSMailManager {

    protected AbstractAWSMailManager() {
    }

    @Override
    public CreateAddonInstanceResult createAddonInstance(CreateAddonInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAddonSubscriptionResult createAddonSubscription(CreateAddonSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateArchiveResult createArchive(CreateArchiveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIngressPointResult createIngressPoint(CreateIngressPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRelayResult createRelay(CreateRelayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRuleSetResult createRuleSet(CreateRuleSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrafficPolicyResult createTrafficPolicy(CreateTrafficPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAddonInstanceResult deleteAddonInstance(DeleteAddonInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAddonSubscriptionResult deleteAddonSubscription(DeleteAddonSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteArchiveResult deleteArchive(DeleteArchiveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIngressPointResult deleteIngressPoint(DeleteIngressPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRelayResult deleteRelay(DeleteRelayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRuleSetResult deleteRuleSet(DeleteRuleSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrafficPolicyResult deleteTrafficPolicy(DeleteTrafficPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAddonInstanceResult getAddonInstance(GetAddonInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAddonSubscriptionResult getAddonSubscription(GetAddonSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArchiveResult getArchive(GetArchiveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArchiveExportResult getArchiveExport(GetArchiveExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArchiveMessageResult getArchiveMessage(GetArchiveMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArchiveMessageContentResult getArchiveMessageContent(GetArchiveMessageContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArchiveSearchResult getArchiveSearch(GetArchiveSearchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArchiveSearchResultsResult getArchiveSearchResults(GetArchiveSearchResultsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIngressPointResult getIngressPoint(GetIngressPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRelayResult getRelay(GetRelayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRuleSetResult getRuleSet(GetRuleSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTrafficPolicyResult getTrafficPolicy(GetTrafficPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAddonInstancesResult listAddonInstances(ListAddonInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAddonSubscriptionsResult listAddonSubscriptions(ListAddonSubscriptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListArchiveExportsResult listArchiveExports(ListArchiveExportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListArchiveSearchesResult listArchiveSearches(ListArchiveSearchesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListArchivesResult listArchives(ListArchivesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIngressPointsResult listIngressPoints(ListIngressPointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRelaysResult listRelays(ListRelaysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRuleSetsResult listRuleSets(ListRuleSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrafficPoliciesResult listTrafficPolicies(ListTrafficPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartArchiveExportResult startArchiveExport(StartArchiveExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartArchiveSearchResult startArchiveSearch(StartArchiveSearchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopArchiveExportResult stopArchiveExport(StopArchiveExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopArchiveSearchResult stopArchiveSearch(StopArchiveSearchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateArchiveResult updateArchive(UpdateArchiveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIngressPointResult updateIngressPoint(UpdateIngressPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRelayResult updateRelay(UpdateRelayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRuleSetResult updateRuleSet(UpdateRuleSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrafficPolicyResult updateTrafficPolicy(UpdateTrafficPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
