/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.RestoreDBClusterFromSnapshotRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RestoreDBClusterFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromSnapshotRequest>, RestoreDBClusterFromSnapshotRequest> {
    public Request<RestoreDBClusterFromSnapshotRequest> marshall(RestoreDBClusterFromSnapshotRequest restoreDBClusterFromSnapshotRequest) {
        if (restoreDBClusterFromSnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterFromSnapshotRequest, "AmazonRDS");
        request.addParameter("Action", "RestoreDBClusterFromSnapshot");
        request.addParameter("Version", "2014-10-31");
        List<String> availabilityZonesList = restoreDBClusterFromSnapshotRequest.getAvailabilityZones();
        int availabilityZonesListIndex = 1;
        for (String availabilityZonesListValue : availabilityZonesList) {
            if (availabilityZonesListValue != null) {
                request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
            }
            ++availabilityZonesListIndex;
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getEngine()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getEngineVersion()));
        }
        if (restoreDBClusterFromSnapshotRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterFromSnapshotRequest.getPort()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDatabaseName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getOptionGroupName()));
        }
        List<String> vpcSecurityGroupIdsList = restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds();
        int vpcSecurityGroupIdsListIndex = 1;
        for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
            if (vpcSecurityGroupIdsListValue != null) {
                request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
            }
            ++vpcSecurityGroupIdsListIndex;
        }
        List<Tag> tagsList = restoreDBClusterFromSnapshotRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

