/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpgradeTarget
implements Serializable,
Cloneable {
    private String engine;
    private String engineVersion;
    private String description;
    private Boolean autoUpgrade;
    private Boolean isMajorVersionUpgrade;
    private SdkInternalList<String> supportedEngineModes;
    private Boolean supportsParallelQuery;
    private Boolean supportsGlobalDatabases;
    private Boolean supportsBabelfish;

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public UpgradeTarget withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public UpgradeTarget withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpgradeTarget withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setAutoUpgrade(Boolean autoUpgrade) {
        this.autoUpgrade = autoUpgrade;
    }

    public Boolean getAutoUpgrade() {
        return this.autoUpgrade;
    }

    public UpgradeTarget withAutoUpgrade(Boolean autoUpgrade) {
        this.setAutoUpgrade(autoUpgrade);
        return this;
    }

    public Boolean isAutoUpgrade() {
        return this.autoUpgrade;
    }

    public void setIsMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
        this.isMajorVersionUpgrade = isMajorVersionUpgrade;
    }

    public Boolean getIsMajorVersionUpgrade() {
        return this.isMajorVersionUpgrade;
    }

    public UpgradeTarget withIsMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
        this.setIsMajorVersionUpgrade(isMajorVersionUpgrade);
        return this;
    }

    public Boolean isMajorVersionUpgrade() {
        return this.isMajorVersionUpgrade;
    }

    public List<String> getSupportedEngineModes() {
        if (this.supportedEngineModes == null) {
            this.supportedEngineModes = new SdkInternalList();
        }
        return this.supportedEngineModes;
    }

    public void setSupportedEngineModes(Collection<String> supportedEngineModes) {
        if (supportedEngineModes == null) {
            this.supportedEngineModes = null;
            return;
        }
        this.supportedEngineModes = new SdkInternalList(supportedEngineModes);
    }

    public UpgradeTarget withSupportedEngineModes(String ... supportedEngineModes) {
        if (this.supportedEngineModes == null) {
            this.setSupportedEngineModes((Collection<String>)new SdkInternalList(supportedEngineModes.length));
        }
        for (String ele : supportedEngineModes) {
            this.supportedEngineModes.add((Object)ele);
        }
        return this;
    }

    public UpgradeTarget withSupportedEngineModes(Collection<String> supportedEngineModes) {
        this.setSupportedEngineModes(supportedEngineModes);
        return this;
    }

    public void setSupportsParallelQuery(Boolean supportsParallelQuery) {
        this.supportsParallelQuery = supportsParallelQuery;
    }

    public Boolean getSupportsParallelQuery() {
        return this.supportsParallelQuery;
    }

    public UpgradeTarget withSupportsParallelQuery(Boolean supportsParallelQuery) {
        this.setSupportsParallelQuery(supportsParallelQuery);
        return this;
    }

    public Boolean isSupportsParallelQuery() {
        return this.supportsParallelQuery;
    }

    public void setSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
        this.supportsGlobalDatabases = supportsGlobalDatabases;
    }

    public Boolean getSupportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public UpgradeTarget withSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
        this.setSupportsGlobalDatabases(supportsGlobalDatabases);
        return this;
    }

    public Boolean isSupportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public void setSupportsBabelfish(Boolean supportsBabelfish) {
        this.supportsBabelfish = supportsBabelfish;
    }

    public Boolean getSupportsBabelfish() {
        return this.supportsBabelfish;
    }

    public UpgradeTarget withSupportsBabelfish(Boolean supportsBabelfish) {
        this.setSupportsBabelfish(supportsBabelfish);
        return this;
    }

    public Boolean isSupportsBabelfish() {
        return this.supportsBabelfish;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getAutoUpgrade() != null) {
            sb.append("AutoUpgrade: ").append(this.getAutoUpgrade()).append(",");
        }
        if (this.getIsMajorVersionUpgrade() != null) {
            sb.append("IsMajorVersionUpgrade: ").append(this.getIsMajorVersionUpgrade()).append(",");
        }
        if (this.getSupportedEngineModes() != null) {
            sb.append("SupportedEngineModes: ").append(this.getSupportedEngineModes()).append(",");
        }
        if (this.getSupportsParallelQuery() != null) {
            sb.append("SupportsParallelQuery: ").append(this.getSupportsParallelQuery()).append(",");
        }
        if (this.getSupportsGlobalDatabases() != null) {
            sb.append("SupportsGlobalDatabases: ").append(this.getSupportsGlobalDatabases()).append(",");
        }
        if (this.getSupportsBabelfish() != null) {
            sb.append("SupportsBabelfish: ").append(this.getSupportsBabelfish());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeTarget)) {
            return false;
        }
        UpgradeTarget other = (UpgradeTarget)obj;
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getAutoUpgrade() == null ^ this.getAutoUpgrade() == null) {
            return false;
        }
        if (other.getAutoUpgrade() != null && !other.getAutoUpgrade().equals(this.getAutoUpgrade())) {
            return false;
        }
        if (other.getIsMajorVersionUpgrade() == null ^ this.getIsMajorVersionUpgrade() == null) {
            return false;
        }
        if (other.getIsMajorVersionUpgrade() != null && !other.getIsMajorVersionUpgrade().equals(this.getIsMajorVersionUpgrade())) {
            return false;
        }
        if (other.getSupportedEngineModes() == null ^ this.getSupportedEngineModes() == null) {
            return false;
        }
        if (other.getSupportedEngineModes() != null && !other.getSupportedEngineModes().equals(this.getSupportedEngineModes())) {
            return false;
        }
        if (other.getSupportsParallelQuery() == null ^ this.getSupportsParallelQuery() == null) {
            return false;
        }
        if (other.getSupportsParallelQuery() != null && !other.getSupportsParallelQuery().equals(this.getSupportsParallelQuery())) {
            return false;
        }
        if (other.getSupportsGlobalDatabases() == null ^ this.getSupportsGlobalDatabases() == null) {
            return false;
        }
        if (other.getSupportsGlobalDatabases() != null && !other.getSupportsGlobalDatabases().equals(this.getSupportsGlobalDatabases())) {
            return false;
        }
        if (other.getSupportsBabelfish() == null ^ this.getSupportsBabelfish() == null) {
            return false;
        }
        return other.getSupportsBabelfish() == null || other.getSupportsBabelfish().equals(this.getSupportsBabelfish());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAutoUpgrade() == null ? 0 : this.getAutoUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getIsMajorVersionUpgrade() == null ? 0 : this.getIsMajorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedEngineModes() == null ? 0 : this.getSupportedEngineModes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsParallelQuery() == null ? 0 : this.getSupportsParallelQuery().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsGlobalDatabases() == null ? 0 : this.getSupportsGlobalDatabases().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsBabelfish() == null ? 0 : this.getSupportsBabelfish().hashCode());
        return hashCode;
    }

    public UpgradeTarget clone() {
        try {
            return (UpgradeTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

