/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.rds.model.ModifyIntegrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyIntegrationRequestMarshaller
implements Marshaller<Request<ModifyIntegrationRequest>, ModifyIntegrationRequest> {
    public Request<ModifyIntegrationRequest> marshall(ModifyIntegrationRequest modifyIntegrationRequest) {
        if (modifyIntegrationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyIntegrationRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyIntegration");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIntegrationRequest.getIntegrationIdentifier() != null) {
            request.addParameter("IntegrationIdentifier", StringUtils.fromString((String)modifyIntegrationRequest.getIntegrationIdentifier()));
        }
        if (modifyIntegrationRequest.getIntegrationName() != null) {
            request.addParameter("IntegrationName", StringUtils.fromString((String)modifyIntegrationRequest.getIntegrationName()));
        }
        if (modifyIntegrationRequest.getDataFilter() != null) {
            request.addParameter("DataFilter", StringUtils.fromString((String)modifyIntegrationRequest.getDataFilter()));
        }
        if (modifyIntegrationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyIntegrationRequest.getDescription()));
        }
        return request;
    }
}

