/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events;

import java.util.List;
import java.util.Map;

public class KafkaEvent {
    private Map<String, List<KafkaEventRecord>> records;
    private String eventSource;
    private String eventSourceArn;
    private String bootstrapServers;

    public static KafkaEventBuilder builder() {
        return new KafkaEventBuilder();
    }

    public Map<String, List<KafkaEventRecord>> getRecords() {
        return this.records;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public String getEventSourceArn() {
        return this.eventSourceArn;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setRecords(Map<String, List<KafkaEventRecord>> records) {
        this.records = records;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public void setEventSourceArn(String eventSourceArn) {
        this.eventSourceArn = eventSourceArn;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaEvent)) {
            return false;
        }
        KafkaEvent other = (KafkaEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<KafkaEventRecord>> this$records = this.getRecords();
        Map<String, List<KafkaEventRecord>> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        String this$eventSource = this.getEventSource();
        String other$eventSource = other.getEventSource();
        if (this$eventSource == null ? other$eventSource != null : !this$eventSource.equals(other$eventSource)) {
            return false;
        }
        String this$eventSourceArn = this.getEventSourceArn();
        String other$eventSourceArn = other.getEventSourceArn();
        if (this$eventSourceArn == null ? other$eventSourceArn != null : !this$eventSourceArn.equals(other$eventSourceArn)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        return !(this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<KafkaEventRecord>> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        String $eventSource = this.getEventSource();
        result = result * 59 + ($eventSource == null ? 43 : $eventSource.hashCode());
        String $eventSourceArn = this.getEventSourceArn();
        result = result * 59 + ($eventSourceArn == null ? 43 : $eventSourceArn.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaEvent(records=" + this.getRecords() + ", eventSource=" + this.getEventSource() + ", eventSourceArn=" + this.getEventSourceArn() + ", bootstrapServers=" + this.getBootstrapServers() + ")";
    }

    public KafkaEvent() {
    }

    public KafkaEvent(Map<String, List<KafkaEventRecord>> records, String eventSource, String eventSourceArn, String bootstrapServers) {
        this.records = records;
        this.eventSource = eventSource;
        this.eventSourceArn = eventSourceArn;
        this.bootstrapServers = bootstrapServers;
    }

    public static class KafkaEventBuilder {
        private Map<String, List<KafkaEventRecord>> records;
        private String eventSource;
        private String eventSourceArn;
        private String bootstrapServers;

        KafkaEventBuilder() {
        }

        public KafkaEventBuilder withRecords(Map<String, List<KafkaEventRecord>> records) {
            this.records = records;
            return this;
        }

        public KafkaEventBuilder withEventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public KafkaEventBuilder withEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public KafkaEventBuilder withBootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public KafkaEvent build() {
            return new KafkaEvent(this.records, this.eventSource, this.eventSourceArn, this.bootstrapServers);
        }

        public String toString() {
            return "KafkaEvent.KafkaEventBuilder(records=" + this.records + ", eventSource=" + this.eventSource + ", eventSourceArn=" + this.eventSourceArn + ", bootstrapServers=" + this.bootstrapServers + ")";
        }
    }

    public static class SchemaMetadata {
        private String schemaId;
        private String dataFormat;

        public static SchemaMetadataBuilder builder() {
            return new SchemaMetadataBuilder();
        }

        public String getSchemaId() {
            return this.schemaId;
        }

        public String getDataFormat() {
            return this.dataFormat;
        }

        public void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        public void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaMetadata)) {
                return false;
            }
            SchemaMetadata other = (SchemaMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$schemaId = this.getSchemaId();
            String other$schemaId = other.getSchemaId();
            if (this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId)) {
                return false;
            }
            String this$dataFormat = this.getDataFormat();
            String other$dataFormat = other.getDataFormat();
            return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SchemaMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $schemaId = this.getSchemaId();
            result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
            String $dataFormat = this.getDataFormat();
            result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
            return result;
        }

        public String toString() {
            return "KafkaEvent.SchemaMetadata(schemaId=" + this.getSchemaId() + ", dataFormat=" + this.getDataFormat() + ")";
        }

        public SchemaMetadata(String schemaId, String dataFormat) {
            this.schemaId = schemaId;
            this.dataFormat = dataFormat;
        }

        public SchemaMetadata() {
        }

        public static class SchemaMetadataBuilder {
            private String schemaId;
            private String dataFormat;

            SchemaMetadataBuilder() {
            }

            public SchemaMetadataBuilder withSchemaId(String schemaId) {
                this.schemaId = schemaId;
                return this;
            }

            public SchemaMetadataBuilder withDataFormat(String dataFormat) {
                this.dataFormat = dataFormat;
                return this;
            }

            public SchemaMetadata build() {
                return new SchemaMetadata(this.schemaId, this.dataFormat);
            }

            public String toString() {
                return "KafkaEvent.SchemaMetadata.SchemaMetadataBuilder(schemaId=" + this.schemaId + ", dataFormat=" + this.dataFormat + ")";
            }
        }
    }

    public static class TopicPartition {
        private String topic;
        private int partition;

        public String toString() {
            return this.topic + "-" + this.partition;
        }

        public static TopicPartitionBuilder builder() {
            return new TopicPartitionBuilder();
        }

        public String getTopic() {
            return this.topic;
        }

        public int getPartition() {
            return this.partition;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopicPartition)) {
                return false;
            }
            TopicPartition other = (TopicPartition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPartition() != other.getPartition()) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TopicPartition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPartition();
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            return result;
        }

        public TopicPartition() {
        }

        public TopicPartition(String topic, int partition) {
            this.topic = topic;
            this.partition = partition;
        }

        public static class TopicPartitionBuilder {
            private String topic;
            private int partition;

            TopicPartitionBuilder() {
            }

            public TopicPartitionBuilder withTopic(String topic) {
                this.topic = topic;
                return this;
            }

            public TopicPartitionBuilder withPartition(int partition) {
                this.partition = partition;
                return this;
            }

            public TopicPartition build() {
                return new TopicPartition(this.topic, this.partition);
            }

            public String toString() {
                return "KafkaEvent.TopicPartition.TopicPartitionBuilder(topic=" + this.topic + ", partition=" + this.partition + ")";
            }
        }
    }

    public static class KafkaEventRecord {
        private String topic;
        private int partition;
        private long offset;
        private long timestamp;
        private String timestampType;
        private String key;
        private String value;
        private List<Map<String, byte[]>> headers;
        private SchemaMetadata keySchemaMetadata;
        private SchemaMetadata valueSchemaMetadata;

        public static KafkaEventRecordBuilder builder() {
            return new KafkaEventRecordBuilder();
        }

        public String getTopic() {
            return this.topic;
        }

        public int getPartition() {
            return this.partition;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getTimestampType() {
            return this.timestampType;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public List<Map<String, byte[]>> getHeaders() {
            return this.headers;
        }

        public SchemaMetadata getKeySchemaMetadata() {
            return this.keySchemaMetadata;
        }

        public SchemaMetadata getValueSchemaMetadata() {
            return this.valueSchemaMetadata;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setTimestampType(String timestampType) {
            this.timestampType = timestampType;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setHeaders(List<Map<String, byte[]>> headers) {
            this.headers = headers;
        }

        public void setKeySchemaMetadata(SchemaMetadata keySchemaMetadata) {
            this.keySchemaMetadata = keySchemaMetadata;
        }

        public void setValueSchemaMetadata(SchemaMetadata valueSchemaMetadata) {
            this.valueSchemaMetadata = valueSchemaMetadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KafkaEventRecord)) {
                return false;
            }
            KafkaEventRecord other = (KafkaEventRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPartition() != other.getPartition()) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            String this$timestampType = this.getTimestampType();
            String other$timestampType = other.getTimestampType();
            if (this$timestampType == null ? other$timestampType != null : !this$timestampType.equals(other$timestampType)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            List<Map<String, byte[]>> this$headers = this.getHeaders();
            List<Map<String, byte[]>> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            SchemaMetadata this$keySchemaMetadata = this.getKeySchemaMetadata();
            SchemaMetadata other$keySchemaMetadata = other.getKeySchemaMetadata();
            if (this$keySchemaMetadata == null ? other$keySchemaMetadata != null : !((Object)this$keySchemaMetadata).equals(other$keySchemaMetadata)) {
                return false;
            }
            SchemaMetadata this$valueSchemaMetadata = this.getValueSchemaMetadata();
            SchemaMetadata other$valueSchemaMetadata = other.getValueSchemaMetadata();
            return !(this$valueSchemaMetadata == null ? other$valueSchemaMetadata != null : !((Object)this$valueSchemaMetadata).equals(other$valueSchemaMetadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KafkaEventRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPartition();
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            String $timestampType = this.getTimestampType();
            result = result * 59 + ($timestampType == null ? 43 : $timestampType.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            List<Map<String, byte[]>> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            SchemaMetadata $keySchemaMetadata = this.getKeySchemaMetadata();
            result = result * 59 + ($keySchemaMetadata == null ? 43 : ((Object)$keySchemaMetadata).hashCode());
            SchemaMetadata $valueSchemaMetadata = this.getValueSchemaMetadata();
            result = result * 59 + ($valueSchemaMetadata == null ? 43 : ((Object)$valueSchemaMetadata).hashCode());
            return result;
        }

        public String toString() {
            return "KafkaEvent.KafkaEventRecord(topic=" + this.getTopic() + ", partition=" + this.getPartition() + ", offset=" + this.getOffset() + ", timestamp=" + this.getTimestamp() + ", timestampType=" + this.getTimestampType() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", headers=" + this.getHeaders() + ", keySchemaMetadata=" + this.getKeySchemaMetadata() + ", valueSchemaMetadata=" + this.getValueSchemaMetadata() + ")";
        }

        public KafkaEventRecord() {
        }

        public KafkaEventRecord(String topic, int partition, long offset, long timestamp, String timestampType, String key, String value, List<Map<String, byte[]>> headers, SchemaMetadata keySchemaMetadata, SchemaMetadata valueSchemaMetadata) {
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
            this.timestamp = timestamp;
            this.timestampType = timestampType;
            this.key = key;
            this.value = value;
            this.headers = headers;
            this.keySchemaMetadata = keySchemaMetadata;
            this.valueSchemaMetadata = valueSchemaMetadata;
        }

        public static class KafkaEventRecordBuilder {
            private String topic;
            private int partition;
            private long offset;
            private long timestamp;
            private String timestampType;
            private String key;
            private String value;
            private List<Map<String, byte[]>> headers;
            private SchemaMetadata keySchemaMetadata;
            private SchemaMetadata valueSchemaMetadata;

            KafkaEventRecordBuilder() {
            }

            public KafkaEventRecordBuilder withTopic(String topic) {
                this.topic = topic;
                return this;
            }

            public KafkaEventRecordBuilder withPartition(int partition) {
                this.partition = partition;
                return this;
            }

            public KafkaEventRecordBuilder withOffset(long offset) {
                this.offset = offset;
                return this;
            }

            public KafkaEventRecordBuilder withTimestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public KafkaEventRecordBuilder withTimestampType(String timestampType) {
                this.timestampType = timestampType;
                return this;
            }

            public KafkaEventRecordBuilder withKey(String key) {
                this.key = key;
                return this;
            }

            public KafkaEventRecordBuilder withValue(String value) {
                this.value = value;
                return this;
            }

            public KafkaEventRecordBuilder withHeaders(List<Map<String, byte[]>> headers) {
                this.headers = headers;
                return this;
            }

            public KafkaEventRecordBuilder withKeySchemaMetadata(SchemaMetadata keySchemaMetadata) {
                this.keySchemaMetadata = keySchemaMetadata;
                return this;
            }

            public KafkaEventRecordBuilder withValueSchemaMetadata(SchemaMetadata valueSchemaMetadata) {
                this.valueSchemaMetadata = valueSchemaMetadata;
                return this;
            }

            public KafkaEventRecord build() {
                return new KafkaEventRecord(this.topic, this.partition, this.offset, this.timestamp, this.timestampType, this.key, this.value, this.headers, this.keySchemaMetadata, this.valueSchemaMetadata);
            }

            public String toString() {
                return "KafkaEvent.KafkaEventRecord.KafkaEventRecordBuilder(topic=" + this.topic + ", partition=" + this.partition + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ", timestampType=" + this.timestampType + ", key=" + this.key + ", value=" + this.value + ", headers=" + this.headers + ", keySchemaMetadata=" + this.keySchemaMetadata + ", valueSchemaMetadata=" + this.valueSchemaMetadata + ")";
            }
        }
    }
}

