/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.JvmWideVariable;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ReadWriteThreadLock {
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();
    private static final JvmWideVariable<ConcurrentMap<Object, ReentrantReadWriteLock>> lockMap = new JvmWideVariable(ReadWriteThreadLock.class.getName(), "lockMap", ReadWriteThreadLock.concurrentMapToken(Object.class, ReentrantReadWriteLock.class), new ConcurrentHashMap());
    private final ReentrantReadWriteLock lock;

    public ReadWriteThreadLock(Object lockObject) {
        Preconditions.checkArgument((lockObject.getClass().getClassLoader() == null ? 1 : 0) != 0, (Object)String.format("%1$s must be loaded by the bootstrap class loader but is loaded by %2$s", lockObject.getClass(), lockObject.getClass().getClassLoader()));
        this.lock = lockMap.get().computeIfAbsent(lockObject, Object2 -> new ReentrantReadWriteLock());
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    private static <K, V> TypeToken<ConcurrentMap<K, V>> concurrentMapToken(Class<K> keyClass, Class<V> valueClass) {
        return new TypeToken<ConcurrentMap<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of(keyClass)).where(new TypeParameter<V>(){}, TypeToken.of(valueClass));
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            ReadWriteThreadLock.this.lock.writeLock().lock();
        }

        @Override
        public void unlock() {
            ReadWriteThreadLock.this.lock.writeLock().unlock();
        }
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            ReadWriteThreadLock.this.lock.readLock().lock();
        }

        @Override
        public void unlock() {
            ReadWriteThreadLock.this.lock.readLock().unlock();
        }
    }

    public static interface Lock {
        public void lock();

        public void unlock();
    }
}

