/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.interceptor;

import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.interceptor.InterceptorChain;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import java.util.Iterator;
import java.util.List;

public class DefaultInterceptorChain
implements InterceptorChain {
    private List<Interceptor> interceptors;
    private Iterator<Interceptor> iterator;

    public DefaultInterceptorChain(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
        this.iterator = interceptors.iterator();
    }

    @Override
    public void intercept(Request request, Response response) throws Exception {
        if (this.iterator.hasNext()) {
            Interceptor interceptor = this.iterator.next();
            boolean success = interceptor.handleRequest(request);
            if (!success) {
                throw new RpcException(6, "request intercept fail");
            }
            interceptor.aroundProcess(request, response, this);
            if (request.getCallback() == null) {
                interceptor.handleResponse(response);
            }
        }
    }
}

