/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.interceptor;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.AbstractInterceptor;
import com.baidu.brpc.interceptor.InterceptorChain;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class LoadBalanceInterceptor
extends AbstractInterceptor {
    protected RpcClient rpcClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aroundProcess(Request request, Response response, InterceptorChain chain) throws Exception {
        RpcException exception = null;
        int currentTryTimes = 0;
        int maxTryTimes = this.rpcClient.getRpcClientOptions().getMaxTryTimes();
        while (currentTryTimes < maxTryTimes) {
            try {
                if (currentTryTimes > 0 && request.getChannel() != null) {
                    if (request.getSelectedInstances() == null) {
                        request.setSelectedInstances(new HashSet<BrpcChannel>(maxTryTimes - 1));
                    }
                    BrpcChannel lastInstance = ChannelInfo.getClientChannelInfo(request.getChannel()).getChannelGroup();
                    request.getSelectedInstances().add(lastInstance);
                }
                this.invokeRpc(request, response);
                break;
            }
            catch (RpcException ex) {
                exception = ex;
                if (exception.getCode() != 6) continue;
                break;
            }
            finally {
                ++currentTryTimes;
            }
        }
        if (response.getResult() == null && response.getRpcFuture() == null) {
            if (exception == null) {
                exception = new RpcException(0, "unknown error");
            }
            response.setException(exception);
        }
    }

    protected void invokeRpc(Request request, Response response) throws Exception {
        this.rpcCore(request, response);
    }

    protected void rpcCore(Request request, Response response) throws Exception {
        RpcFuture future = (RpcFuture)this.rpcClient.sendRequest(request);
        if (future.isAsync()) {
            response.setRpcFuture(future);
        } else {
            response.setResult(future.get(request.getReadTimeoutMillis().intValue(), TimeUnit.MILLISECONDS));
            response.setCorrelationId(future.getCorrelationId());
        }
    }

    public void setRpcClient(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }
}

