/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming;

import com.baidu.brpc.client.instance.ServiceInstance;
import com.baidu.brpc.naming.BrpcURL;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.naming.NotifyListener;
import com.baidu.brpc.naming.RegisterInfo;
import com.baidu.brpc.naming.SubscribeInfo;
import com.baidu.brpc.utils.CustomThreadFactory;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNamingService
implements NamingService {
    private static final Logger LOG = LoggerFactory.getLogger(FileNamingService.class);
    private BrpcURL namingUrl;
    private String filePath;
    private List<ServiceInstance> lastInstances = new ArrayList<ServiceInstance>();
    private Timer namingServiceTimer;
    private long lastModified;
    private int updateInterval;

    public FileNamingService(BrpcURL namingUrl) {
        Validate.notNull(namingUrl);
        Validate.notNull(namingUrl.getPath());
        this.namingUrl = namingUrl;
        this.filePath = namingUrl.getPath();
        this.updateInterval = namingUrl.getIntParameter("interval", 5000);
        this.namingServiceTimer = new HashedWheelTimer(new CustomThreadFactory("namingService-timer-thread"));
    }

    @Override
    public List<ServiceInstance> lookup(SubscribeInfo subscribeInfo) {
        ArrayList<ServiceInstance> list = new ArrayList<ServiceInstance>();
        int lineNum = 0;
        BufferedReader reader = null;
        try {
            String line;
            File file = new File(this.filePath);
            long lastModified = file.lastModified();
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                String[] ipPort = (line = line.trim()).split(":");
                if (ipPort.length != 2) {
                    LOG.warn("Invalid address format: " + line);
                    continue;
                }
                ServiceInstance instance = new ServiceInstance(ipPort[0].trim(), Integer.valueOf(ipPort[1].trim()));
                list.add(instance);
            }
            LOG.debug("Got " + list.size() + " servers (out of " + lineNum + ')' + " from " + this.filePath);
            this.lastModified = lastModified;
            ArrayList<ServiceInstance> arrayList = list;
            return arrayList;
        }
        catch (IOException ex) {
            LOG.warn("read file error, fileName={}", (Object)this.filePath);
            throw new RuntimeException("read naming file error");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex2) {
                    LOG.warn("close failed");
                }
            }
        }
    }

    @Override
    public void subscribe(SubscribeInfo subscribeInfo, final NotifyListener listener) {
        this.namingServiceTimer.newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                try {
                    File file = new File(FileNamingService.this.filePath);
                    long currentModified = file.lastModified();
                    if (currentModified > FileNamingService.this.lastModified) {
                        List<ServiceInstance> currentInstances = FileNamingService.this.lookup(null);
                        Collection<ServiceInstance> addList = CollectionUtils.subtract(currentInstances, FileNamingService.this.lastInstances);
                        Collection<ServiceInstance> deleteList = CollectionUtils.subtract(FileNamingService.this.lastInstances, currentInstances);
                        listener.notify(addList, deleteList);
                        FileNamingService.this.lastInstances = currentInstances;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileNamingService.this.namingServiceTimer.newTimeout(this, FileNamingService.this.updateInterval, TimeUnit.MILLISECONDS);
            }
        }, this.updateInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unsubscribe(SubscribeInfo subscribeInfo) {
        this.namingServiceTimer.stop();
    }

    @Override
    public void register(RegisterInfo registerInfo) {
    }

    @Override
    public void unregister(RegisterInfo registerInfo) {
    }

    @Override
    public void destroy() {
    }
}

