/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.nshead;

import com.baidu.brpc.exceptions.BadSchemaException;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class NSHead {
    public static final int NSHEAD_LENGTH = 36;
    public static final int NSHEAD_MAGIC_NUM = -76508268;
    public static final int PROVIDER_LENGTH = 16;
    private static final byte[] ZEROS = new byte[16];
    public short id = 0;
    public short version = 1;
    public int logId;
    public String provider = "";
    public int magicNumber = -76508268;
    public int reserved = 0;
    public int bodyLength = 0;

    public NSHead(int logId, short id, short version, String provider, int bodyLength) {
        this.logId = logId;
        this.id = id;
        this.version = version;
        if (provider != null) {
            this.provider = provider;
        }
        this.bodyLength = bodyLength;
    }

    public NSHead(int logId, int bodyLength) {
        this.logId = logId;
        this.bodyLength = bodyLength;
    }

    public NSHead() {
    }

    public static NSHead fromByteBuf(ByteBuf buf) throws BadSchemaException {
        int n;
        NSHead head = new NSHead();
        if (buf.readableBytes() < 36) {
            throw new IllegalArgumentException("not enough bytes to read");
        }
        head.id = buf.readShortLE();
        head.version = buf.readShortLE();
        head.logId = buf.readIntLE();
        byte[] bytes = new byte[16];
        buf.readBytes(bytes);
        for (n = 0; n < bytes.length && bytes[n] != 0; ++n) {
        }
        head.provider = new String(bytes, 0, n);
        head.magicNumber = buf.readIntLE();
        if (head.magicNumber != -76508268) {
            throw new BadSchemaException("nshead magic number does not match");
        }
        head.reserved = buf.readIntLE();
        head.bodyLength = buf.readIntLE();
        return head;
    }

    public byte[] toBytes() {
        ByteBuffer buf = ByteBuffer.allocate(36);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort(this.id);
        buf.putShort(this.version);
        buf.putInt(this.logId);
        byte[] providerBytes = this.provider.getBytes();
        if (providerBytes.length >= 16) {
            buf.put(providerBytes, 0, 16);
        } else {
            buf.put(providerBytes, 0, providerBytes.length);
            buf.put(ZEROS, 0, 16 - providerBytes.length);
        }
        buf.putInt(this.magicNumber);
        buf.putInt(this.reserved);
        buf.putInt(this.bodyLength);
        return buf.array();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append(this.version).append(this.logId).append(this.magicNumber).append(this.reserved).append(this.bodyLength).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NSHead)) {
            return false;
        }
        NSHead other = (NSHead)obj;
        return new EqualsBuilder().append(this.id, other.id).append(this.version, other.version).append(this.logId, other.logId).append(this.reserved, other.reserved).append(this.bodyLength, other.bodyLength).isEquals();
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", Integer.toHexString(this.id)).append("version", Integer.toHexString(this.version)).append("logId", Long.toHexString(this.logId) + "(" + this.logId + ")").append("provider", this.provider).append("magicNumber", Integer.toHexString(this.magicNumber)).append("reserved", Integer.toHexString(this.reserved)).append("bodyLength", Integer.toHexString(this.bodyLength)).toString();
    }
}

