/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.nshead;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.protocol.AbstractProtocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.protocol.nshead.NSHead;
import com.baidu.brpc.protocol.nshead.NSHeadPacket;
import com.baidu.brpc.server.ServiceManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NSHeadRpcProtocol
extends AbstractProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(NSHeadRpcProtocol.class);
    protected String encoding = "utf-8";

    public NSHeadRpcProtocol(String encoding) {
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        Validate.notEmpty(request.getArgs(), "args must not be empty", new Object[0]);
        byte[] bodyBytes = this.encodeBody(request.getArgs()[0], request.getRpcMethodInfo());
        NSHead nsHead = request.getNsHead();
        nsHead.bodyLength = bodyBytes.length;
        byte[] nsHeadBytes = nsHead.toBytes();
        return Unpooled.wrappedBuffer(nsHeadBytes, bodyBytes);
    }

    @Override
    public Response decodeResponse(Object in, ChannelHandlerContext ctx) throws Exception {
        NSHeadPacket packet = (NSHeadPacket)in;
        RpcResponse rpcResponse = new RpcResponse();
        ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
        Long correlationId = channelInfo.getCorrelationId();
        rpcResponse.setCorrelationId(correlationId);
        RpcFuture future = channelInfo.removeRpcFuture(rpcResponse.getCorrelationId());
        if (future == null) {
            return rpcResponse;
        }
        rpcResponse.setRpcFuture(future);
        Object responseBody = this.decodeBody(packet.getBodyBuf(), future.getRpcMethodInfo());
        if (responseBody == null) {
            return null;
        }
        rpcResponse.setResult(responseBody);
        return rpcResponse;
    }

    @Override
    public ByteBuf encodeResponse(Request request, Response response) throws Exception {
        byte[] bodyBytes = this.encodeBody(response.getResult(), response.getRpcMethodInfo());
        NSHead nsHead = new NSHead((int)response.getLogId(), bodyBytes.length);
        byte[] headBytes = nsHead.toBytes();
        return Unpooled.wrappedBuffer(headBytes, bodyBytes);
    }

    @Override
    public Request decodeRequest(Object packet) throws Exception {
        Request request = this.createRequest();
        NSHeadPacket nsHeadPacket = (NSHeadPacket)packet;
        request.setLogId(nsHeadPacket.getNsHead().logId);
        ServiceManager serviceManager = ServiceManager.getInstance();
        Map<String, RpcMethodInfo> serviceInfoMap = serviceManager.getServiceMap();
        if (serviceInfoMap.size() == 0) {
            String errMsg = "serviceInfoMap == 0";
            LOG.error(errMsg);
            request.setException(new RpcException(3, errMsg));
            return request;
        }
        RpcMethodInfo rpcMethodInfo = serviceInfoMap.entrySet().iterator().next().getValue();
        if (rpcMethodInfo == null) {
            String errMsg = "serviceInfo is null in server";
            LOG.error(errMsg);
            request.setException(new RpcException(3, errMsg));
            return request;
        }
        request.setServiceName(rpcMethodInfo.getServiceName());
        request.setMethodName(rpcMethodInfo.getMethodName());
        request.setRpcMethodInfo(rpcMethodInfo);
        Object body = this.decodeBody(nsHeadPacket.getBodyBuf(), rpcMethodInfo);
        request.setTarget(rpcMethodInfo.getTarget());
        request.setArgs(new Object[]{body});
        request.setTargetMethod(rpcMethodInfo.getMethod());
        return request;
    }

    @Override
    public boolean returnChannelBeforeResponse() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NSHeadPacket decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws BadSchemaException, TooBigDataException, NotEnoughDataException {
        if (in.readableBytes() < 36) {
            throw notEnoughDataException;
        }
        NSHeadPacket packet = new NSHeadPacket();
        ByteBuf fixHeaderBuf = in.retainedSlice(36);
        try {
            NSHead nsHead = NSHead.fromByteBuf(fixHeaderBuf);
            packet.setNsHead(nsHead);
            int bodyLength = nsHead.bodyLength;
            if (bodyLength > 0x20000000) {
                throw new TooBigDataException("to big body size:" + bodyLength);
            }
            if (in.readableBytes() < 36 + bodyLength) {
                throw notEnoughDataException;
            }
            in.skipBytes(36);
            ByteBuf bodyBuf = in.readRetainedSlice(bodyLength);
            packet.setBodyBuf(bodyBuf);
            NSHeadPacket nSHeadPacket = packet;
            return nSHeadPacket;
        }
        finally {
            fixHeaderBuf.release();
        }
    }

    public abstract byte[] encodeBody(Object var1, RpcMethodInfo var2);

    public abstract Object decodeBody(ByteBuf var1, RpcMethodInfo var2);
}

