/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.pbrpc;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.compress.Compress;
import com.baidu.brpc.compress.CompressManager;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.protocol.AbstractProtocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.protocol.nshead.NSHead;
import com.baidu.brpc.protocol.pbrpc.PublicPbRpcPacket;
import com.baidu.brpc.protocol.pbrpc.PublicPbrpcProto;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.utils.ProtobufUtils;
import com.baidu.brpc.utils.RpcMetaUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetAddress;
import java.util.Calendar;
import org.apache.tools.ant.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicPbrpcProtocol
extends AbstractProtocol {
    private static final Logger log = LoggerFactory.getLogger(PublicPbrpcProtocol.class);
    private static final String VERSION = "pbrpc=1.0";
    private static final String CHARSET = "utf-8";
    private static final String SUCCESS_TEXT = "success";
    private static final String TIME_FORMAT = "%Y%m%d%H%M%S";
    private static final String PROVIDER = "__pbrpc__";
    private static final int CONTENT_TYPE = 1;
    private static final int COMPRESS_TYPE = 1;
    private static final int NSHEAD_VERSION = 1000;
    private static final CompressManager compressManager = CompressManager.getInstance();

    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        int methodIndex;
        RpcMetaUtils.RpcMetaInfo rpcMetaInfo = RpcMetaUtils.parseRpcMeta(request.getTargetMethod());
        try {
            methodIndex = Integer.valueOf(rpcMetaInfo.getMethodName());
        }
        catch (NumberFormatException ex) {
            String errorMsg = "methodName must be integer when using pbrpc, it is equal to proto method sequence from 0";
            log.warn(errorMsg);
            throw new RpcException(5, errorMsg, ex);
        }
        PublicPbrpcProto.RequestHead.Builder headBuilder = PublicPbrpcProto.RequestHead.newBuilder();
        headBuilder.setFromHost(InetAddress.getLocalHost().getHostAddress());
        headBuilder.setContentType(1);
        headBuilder.setConnection(false);
        headBuilder.setCharset(CHARSET);
        headBuilder.setCreateTime(DateUtils.format(Calendar.getInstance().getTime(), TIME_FORMAT));
        headBuilder.setLogId(request.getLogId());
        headBuilder.setCompressType(request.getCompressType());
        PublicPbrpcProto.RequestBody.Builder bodyBuilder = PublicPbrpcProto.RequestBody.newBuilder();
        bodyBuilder.setVersion(VERSION);
        bodyBuilder.setCharset(CHARSET);
        bodyBuilder.setService(request.getServiceName());
        bodyBuilder.setMethodId(methodIndex);
        bodyBuilder.setId(request.getCorrelationId());
        Compress compress = compressManager.getCompress(request.getCompressType());
        ByteBuf protoBuf = compress.compressInput(request.getArgs()[0], request.getRpcMethodInfo());
        bodyBuilder.setSerializedRequest(ByteString.copyFrom(protoBuf.nioBuffer()));
        PublicPbrpcProto.PublicPbrpcRequest pbreq = PublicPbrpcProto.PublicPbrpcRequest.newBuilder().setRequestHead(headBuilder.build()).addRequestBody(bodyBuilder.build()).build();
        NSHead nsHead = new NSHead();
        nsHead.logId = (int)request.getLogId();
        nsHead.magicNumber = -76508268;
        nsHead.provider = PROVIDER;
        nsHead.version = (short)1000;
        nsHead.bodyLength = pbreq.getSerializedSize();
        byte[] nsHeadBytes = nsHead.toBytes();
        return Unpooled.wrappedBuffer(nsHeadBytes, request.getRpcMethodInfo().inputEncode(pbreq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicPbRpcPacket decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws BadSchemaException, TooBigDataException, NotEnoughDataException {
        if (in.readableBytes() < 36) {
            throw notEnoughDataException;
        }
        PublicPbRpcPacket packet = new PublicPbRpcPacket();
        ByteBuf fixHeaderBuf = in.retainedSlice(36);
        try {
            NSHead nsHead = NSHead.fromByteBuf(fixHeaderBuf);
            packet.setNsHead(nsHead);
            int bodyLength = nsHead.bodyLength;
            if (bodyLength > 0x20000000) {
                throw new TooBigDataException("to big body size:" + bodyLength);
            }
            if (in.readableBytes() < 36 + bodyLength) {
                throw notEnoughDataException;
            }
            in.skipBytes(36);
            ByteBuf bodyBuf = in.readRetainedSlice(bodyLength);
            packet.setBody(bodyBuf);
            PublicPbRpcPacket publicPbRpcPacket = packet;
            return publicPbRpcPacket;
        }
        finally {
            fixHeaderBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response decodeResponse(Object in, ChannelHandlerContext ctx) throws Exception {
        RpcResponse rpcResponse;
        block9: {
            PublicPbRpcPacket packet = (PublicPbRpcPacket)in;
            rpcResponse = new RpcResponse();
            ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
            ByteBuf bodyBuf = packet.getBody();
            try {
                Object responseBody;
                PublicPbrpcProto.PublicPbrpcResponse pbResponse = (PublicPbrpcProto.PublicPbrpcResponse)ProtobufUtils.parseFrom(bodyBuf, (Message)PublicPbrpcProto.PublicPbrpcResponse.getDefaultInstance());
                PublicPbrpcProto.ResponseBody body = pbResponse.getResponseBody(0);
                PublicPbrpcProto.ResponseHead head = pbResponse.getResponseHead();
                if (head.getCode() != 0) {
                    rpcResponse.setException(new RpcException(head.getText()));
                    break block9;
                }
                rpcResponse.setCorrelationId(body.getId());
                RpcFuture future = channelInfo.removeRpcFuture(rpcResponse.getCorrelationId());
                if (future == null) {
                    RpcResponse rpcResponse2 = rpcResponse;
                    return rpcResponse2;
                }
                rpcResponse.setRpcFuture(future);
                int compressType = head.getCompressType();
                try {
                    Compress compress = compressManager.getCompress(compressType);
                    responseBody = compress.uncompressOutput(body.getSerializedResponse().toByteArray(), future.getRpcMethodInfo());
                }
                catch (Exception ex) {
                    String errorMsg = String.format("decode failed, msg=%s", ex.getMessage());
                    log.error(errorMsg);
                    throw new RpcException(5, errorMsg, ex);
                }
                rpcResponse.setResult(responseBody);
            }
            finally {
                if (bodyBuf != null) {
                    bodyBuf.release();
                }
            }
        }
        return rpcResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request decodeRequest(Object packet) throws Exception {
        Request request = this.getRequest();
        PublicPbRpcPacket pbPacket = (PublicPbRpcPacket)packet;
        ByteBuf bodyBuf = pbPacket.getBody();
        try {
            PublicPbrpcProto.PublicPbrpcRequest pbRequest = (PublicPbrpcProto.PublicPbrpcRequest)ProtobufUtils.parseFrom(bodyBuf, (Message)PublicPbrpcProto.PublicPbrpcRequest.getDefaultInstance());
            PublicPbrpcProto.RequestBody body = pbRequest.getRequestBody(0);
            PublicPbrpcProto.RequestHead head = pbRequest.getRequestHead();
            request.setCorrelationId(body.getId());
            request.setLogId(head.getLogId());
            int compressType = head.getCompressType();
            request.setCompressType(compressType);
            ServiceManager serviceManager = ServiceManager.getInstance();
            RpcMethodInfo rpcMethodInfo = serviceManager.getService(body.getService(), String.valueOf(body.getMethodId()));
            if (rpcMethodInfo == null) {
                String errorMsg = String.format("Fail to find service=%s, methodIndex=%s", body.getService(), body.getMethodId());
                request.setException(new RpcException(3, errorMsg));
                Request request2 = request;
                return request2;
            }
            request.setRpcMethodInfo(rpcMethodInfo);
            request.setTargetMethod(rpcMethodInfo.getMethod());
            request.setTarget(rpcMethodInfo.getTarget());
            try {
                Compress compress = compressManager.getCompress(compressType);
                Object requestProto = compress.uncompressInput(body.getSerializedRequest().toByteArray(), rpcMethodInfo);
                request.setArgs(new Object[]{requestProto});
            }
            catch (Exception ex) {
                String errorMsg = String.format("decode failed, msg=%s", ex.getMessage());
                log.error(errorMsg);
                throw new RpcException(5, errorMsg, ex);
            }
            Request request3 = request;
            return request3;
        }
        finally {
            if (bodyBuf != null) {
                bodyBuf.release();
            }
        }
    }

    @Override
    public ByteBuf encodeResponse(Request request, Response response) throws Exception {
        PublicPbrpcProto.ResponseHead.Builder headBuilder = PublicPbrpcProto.ResponseHead.newBuilder();
        headBuilder.setFromHost(InetAddress.getLocalHost().getHostAddress());
        PublicPbrpcProto.ResponseBody.Builder bodyBuilder = PublicPbrpcProto.ResponseBody.newBuilder();
        bodyBuilder.setVersion(VERSION);
        bodyBuilder.setId(request.getCorrelationId());
        if (response.getException() != null) {
            headBuilder.setCode(2001);
            headBuilder.setText(response.getException().getMessage());
        } else {
            headBuilder.setCode(0);
            headBuilder.setText(SUCCESS_TEXT);
            headBuilder.setCompressType(request.getCompressType());
            Compress compress = compressManager.getCompress(request.getCompressType());
            ByteBuf responseProtoBuf = compress.compressOutput(response.getResult(), response.getRpcMethodInfo());
            bodyBuilder.setSerializedResponse(ByteString.copyFrom(responseProtoBuf.nioBuffer()));
        }
        PublicPbrpcProto.PublicPbrpcResponse pbres = PublicPbrpcProto.PublicPbrpcResponse.newBuilder().setResponseHead(headBuilder.build()).addResponseBody(bodyBuilder.build()).build();
        NSHead nsHead = new NSHead();
        nsHead.logId = (int)request.getLogId();
        nsHead.magicNumber = -76508268;
        nsHead.provider = PROVIDER;
        nsHead.version = (short)1000;
        nsHead.bodyLength = pbres.getSerializedSize();
        byte[] nsHeadBytes = nsHead.toBytes();
        return Unpooled.wrappedBuffer(nsHeadBytes, request.getRpcMethodInfo().inputEncode(pbres));
    }

    @Override
    public boolean isCoexistence() {
        return false;
    }
}

