/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.protobuf.format;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import com.googlecode.protobuf.format.AbstractCharBasedFormatter;
import com.googlecode.protobuf.format.ProtobufFormatter;
import com.googlecode.protobuf.format.util.TextUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XmlFormat
extends AbstractCharBasedFormatter {
    @Override
    public void print(Message message, Appendable output) throws IOException {
        XmlGenerator generator = new XmlGenerator(output);
        String messageName = message.getDescriptorForType().getName();
        generator.print("<");
        generator.print(messageName);
        generator.print(">");
        this.print(message, generator);
        generator.print("</");
        generator.print(messageName);
        generator.print(">");
    }

    @Override
    public void print(UnknownFieldSet fields, Appendable output) throws IOException {
        XmlGenerator generator = new XmlGenerator(output);
        generator.print("<message>");
        this.printUnknownFields(fields, generator);
        generator.print("</message>");
    }

    private void print(Message message, XmlGenerator generator) throws IOException {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> field : message.getAllFields().entrySet()) {
            this.printField(field.getKey(), field.getValue(), generator);
        }
        this.printUnknownFields(message.getUnknownFields(), generator);
    }

    public void printField(Descriptors.FieldDescriptor field, Object value, XmlGenerator generator) throws IOException {
        if (field.isRepeated()) {
            for (Object element : (List)value) {
                this.printSingleField(field, element, generator);
            }
        } else {
            this.printSingleField(field, value, generator);
        }
    }

    private void printSingleField(Descriptors.FieldDescriptor field, Object value, XmlGenerator generator) throws IOException {
        if (field.isExtension()) {
            generator.print("<extension type=\"");
            if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                generator.print(field.getMessageType().getFullName());
            } else {
                generator.print(field.getFullName());
            }
            generator.print("\">");
        } else {
            generator.print("<");
            if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            generator.print(">");
        }
        this.printFieldValue(field, value, generator);
        if (!field.isExtension()) {
            generator.print("</");
            if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            generator.print(">");
        } else {
            generator.print("</extension>");
        }
    }

    private void printFieldValue(Descriptors.FieldDescriptor field, Object value, XmlGenerator generator) throws IOException {
        switch (field.getType()) {
            case INT32: 
            case INT64: 
            case SINT32: 
            case SINT64: 
            case SFIXED32: 
            case SFIXED64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOL: {
                generator.print(value.toString());
                break;
            }
            case UINT32: 
            case FIXED32: {
                generator.print(TextUtils.unsignedToString((Integer)value));
                break;
            }
            case UINT64: 
            case FIXED64: {
                generator.print(TextUtils.unsignedToString((Long)value));
                break;
            }
            case STRING: {
                generator.print(XmlFormat.escapeText((String)value));
                break;
            }
            case BYTES: {
                generator.print(XmlFormat.escapeBytes((ByteString)value));
                break;
            }
            case ENUM: {
                generator.print(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                this.print((Message)value, generator);
            }
        }
    }

    private void printUnknownFields(UnknownFieldSet unknownFields, XmlGenerator generator) throws IOException {
        for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
            UnknownFieldSet.Field field = entry.getValue();
            String key = entry.getKey().toString();
            Iterator<Object> iterator = field.getVarintList().iterator();
            while (iterator.hasNext()) {
                long value = iterator.next();
                this.printUnknownField(key, TextUtils.unsignedToString(value), generator);
            }
            iterator = field.getFixed32List().iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                this.printUnknownField(key, String.format((Locale)null, "0x%08x", value), generator);
            }
            iterator = field.getFixed64List().iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                this.printUnknownField(key, String.format((Locale)null, "0x%016x", value), generator);
            }
            for (ByteString value : field.getLengthDelimitedList()) {
                this.printUnknownField(key, XmlFormat.escapeBytes(value), generator);
            }
            for (UnknownFieldSet value : field.getGroupList()) {
                generator.print("<unknown-field index=\"");
                generator.print(key);
                generator.print("\">");
                this.printUnknownFields(value, generator);
                generator.print("</unknown-field>");
            }
        }
    }

    private void printUnknownField(CharSequence fieldKey, CharSequence fieldValue, XmlGenerator generator) throws IOException {
        generator.print("<unknown-field index=\"");
        generator.print(fieldKey);
        generator.print("\">");
        generator.print(fieldValue);
        generator.print("</unknown-field>");
    }

    @Override
    public void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ProtobufFormatter.ParseException {
        Tokenizer tokenizer = new Tokenizer(input);
        this.consumeOpeningElement(tokenizer);
        while (!tokenizer.tryConsume("</")) {
            this.mergeField(tokenizer, extensionRegistry, builder);
        }
        this.consumeClosingElement(tokenizer);
    }

    private String consumeOpeningElement(Tokenizer tokenizer) throws ProtobufFormatter.ParseException {
        tokenizer.consume("<");
        String openingElement = tokenizer.consumeIdentifier();
        tokenizer.consume(">");
        return openingElement;
    }

    private void consumeClosingElement(Tokenizer tokenizer) throws ProtobufFormatter.ParseException {
        tokenizer.tryConsume("</");
        tokenizer.nextToken();
        tokenizer.consume(">");
    }

    private String consumeExtensionIdentifier(Tokenizer tokenizer) throws ProtobufFormatter.ParseException {
        tokenizer.consume("type");
        tokenizer.consume("=");
        return tokenizer.consumeIdentifier();
    }

    private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ProtobufFormatter.ParseException {
        Descriptors.FieldDescriptor field;
        CharSequence name;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        ExtensionRegistry.ExtensionInfo extension = null;
        tokenizer.consume("<");
        if (tokenizer.tryConsume("extension")) {
            name = new StringBuilder(this.consumeExtensionIdentifier(tokenizer));
            while (tokenizer.tryConsume(".")) {
                ((StringBuilder)name).append(".");
                ((StringBuilder)name).append(tokenizer.consumeIdentifier());
            }
            extension = extensionRegistry.findExtensionByName(((StringBuilder)name).toString());
            if (extension == null) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" not found in the ExtensionRegistry.");
            }
            if (extension.descriptor.getContainingType() != type) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" does not extend message type \"" + type.getFullName() + "\".");
            }
            field = extension.descriptor;
        } else {
            String lowerName;
            name = tokenizer.consumeIdentifier();
            field = type.findFieldByName((String)name);
            if (field == null && (field = type.findFieldByName(lowerName = ((String)name).toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                field = null;
            }
            if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(name)) {
                field = null;
            }
            if (field == null) {
                throw tokenizer.parseExceptionPreviousToken("Message type \"" + type.getFullName() + "\" has no field named \"" + (String)name + "\".");
            }
        }
        tokenizer.consume(">");
        Object value = this.handleValue(tokenizer, extensionRegistry, builder, field, extension);
        if (field.isRepeated()) {
            builder.addRepeatedField(field, value);
        } else {
            builder.setField(field, value);
        }
        this.consumeClosingElement(tokenizer);
    }

    private Object handleValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension) throws ProtobufFormatter.ParseException {
        Object value = null;
        value = field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? this.handleObject(tokenizer, extensionRegistry, builder, field, extension) : this.handlePrimitive(tokenizer, field);
        return value;
    }

    private Object handlePrimitive(Tokenizer tokenizer, Descriptors.FieldDescriptor field) throws ProtobufFormatter.ParseException {
        Object value = null;
        switch (field.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                value = tokenizer.consumeInt32();
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                value = tokenizer.consumeInt64();
                break;
            }
            case UINT32: 
            case FIXED32: {
                value = tokenizer.consumeUInt32();
                break;
            }
            case UINT64: 
            case FIXED64: {
                value = tokenizer.consumeUInt64();
                break;
            }
            case FLOAT: {
                value = Float.valueOf(tokenizer.consumeFloat());
                break;
            }
            case DOUBLE: {
                value = tokenizer.consumeDouble();
                break;
            }
            case BOOL: {
                value = tokenizer.consumeBoolean();
                break;
            }
            case STRING: {
                value = tokenizer.consumeString();
                break;
            }
            case BYTES: {
                value = tokenizer.consumeByteString();
                break;
            }
            case ENUM: {
                Descriptors.EnumDescriptor enumType = field.getEnumType();
                if (tokenizer.lookingAtInteger()) {
                    int number = tokenizer.consumeInt32();
                    value = enumType.findValueByNumber(number);
                    if (value != null) break;
                    throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + ".");
                }
                String id = tokenizer.consumeIdentifier();
                value = enumType.findValueByName(id);
                if (value != null) break;
                throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id + "\".");
            }
            case MESSAGE: 
            case GROUP: {
                throw new RuntimeException("Can't get here.");
            }
        }
        return value;
    }

    private Object handleObject(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension) throws ProtobufFormatter.ParseException {
        Message.Builder subBuilder = extension == null ? builder.newBuilderForField(field) : extension.defaultInstance.newBuilderForType();
        String endToken = "</";
        while (!tokenizer.tryConsume(endToken)) {
            if (tokenizer.atEnd()) {
                throw tokenizer.parseException("Expected \"" + endToken + "\".");
            }
            this.mergeField(tokenizer, extensionRegistry, subBuilder);
        }
        Message value = subBuilder.build();
        return value;
    }

    static String escapeBytes(ByteString input) {
        StringBuilder builder = new StringBuilder(input.size());
        block12: for (int i = 0; i < input.size(); ++i) {
            byte b = input.byteAt(i);
            switch (b) {
                case 7: {
                    builder.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder.toString();
    }

    static ByteString unescapeBytes(CharSequence input) throws InvalidEscapeSequence {
        byte[] result = new byte[input.length()];
        int pos = 0;
        block13: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                if (i + 1 < input.length()) {
                    int code;
                    if (TextUtils.isOctal(c = input.charAt(++i))) {
                        code = TextUtils.digitValue(c);
                        if (i + 1 < input.length() && TextUtils.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + TextUtils.digitValue(input.charAt(++i));
                        }
                        if (i + 1 < input.length() && TextUtils.isOctal(input.charAt(i + 1))) {
                            code = code * 8 + TextUtils.digitValue(input.charAt(++i));
                        }
                        result[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 'a': {
                            result[pos++] = 7;
                            continue block13;
                        }
                        case 'b': {
                            result[pos++] = 8;
                            continue block13;
                        }
                        case 'f': {
                            result[pos++] = 12;
                            continue block13;
                        }
                        case 'n': {
                            result[pos++] = 10;
                            continue block13;
                        }
                        case 'r': {
                            result[pos++] = 13;
                            continue block13;
                        }
                        case 't': {
                            result[pos++] = 9;
                            continue block13;
                        }
                        case 'v': {
                            result[pos++] = 11;
                            continue block13;
                        }
                        case '\\': {
                            result[pos++] = 92;
                            continue block13;
                        }
                        case '\'': {
                            result[pos++] = 39;
                            continue block13;
                        }
                        case '\"': {
                            result[pos++] = 34;
                            continue block13;
                        }
                        case 'x': {
                            code = 0;
                            if (i + 1 >= input.length() || !TextUtils.isHex(input.charAt(i + 1))) {
                                throw new InvalidEscapeSequence("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextUtils.digitValue(input.charAt(++i));
                            if (i + 1 < input.length() && TextUtils.isHex(input.charAt(i + 1))) {
                                code = code * 16 + TextUtils.digitValue(input.charAt(++i));
                            }
                            result[pos++] = (byte)code;
                            continue block13;
                        }
                        default: {
                            throw new InvalidEscapeSequence("Invalid escape sequence: '\\" + c + "'");
                        }
                    }
                }
                throw new InvalidEscapeSequence("Invalid escape sequence: '\\' at end of string.");
            }
            result[pos++] = (byte)c;
        }
        return ByteString.copyFrom(result, 0, pos);
    }

    static String escapeText(String input) {
        return XmlFormat.escapeBytes(ByteString.copyFromUtf8(input));
    }

    static String unescapeText(String input) throws InvalidEscapeSequence {
        return XmlFormat.unescapeBytes(input).toStringUtf8();
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)XmlFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)XmlFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return XmlFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return XmlFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        long result = 0L;
        if (numberText.length() < 16) {
            result = Long.parseLong(numberText, radix);
            if (negative) {
                result = -result;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result >= 0x100000000L || result < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            result = bigValue.longValue();
        }
        return result;
    }

    static class InvalidEscapeSequence
    extends IOException {
        private static final long serialVersionUID = 1L;

        public InvalidEscapeSequence(String description) {
            super(description);
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("extension|[a-zA-Z_\\s;@][0-9a-zA-Z_\\s;@+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|</|[\\\\0-9]++|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        public Tokenizer(CharSequence text) {
            this.text = text;
            this.matcher = WHITESPACE.matcher(text);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ProtobufFormatter.ParseException {
            if (!this.tryConsume(token)) {
                throw this.parseException("Expected \"" + token + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public String consumeIdentifier() throws ProtobufFormatter.ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '\"') continue;
                throw this.parseException("Expected identifier. -" + c);
            }
            String result = this.currentToken;
            result = result.replaceAll("\"|'", "");
            this.nextToken();
            return result;
        }

        public int consumeInt32() throws ProtobufFormatter.ParseException {
            try {
                int result = XmlFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public int consumeUInt32() throws ProtobufFormatter.ParseException {
            try {
                int result = XmlFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeInt64() throws ProtobufFormatter.ParseException {
            try {
                long result = XmlFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeUInt64() throws ProtobufFormatter.ParseException {
            try {
                long result = XmlFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public double consumeDouble() throws ProtobufFormatter.ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public float consumeFloat() throws ProtobufFormatter.ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean consumeBoolean() throws ProtobufFormatter.ParseException {
            if (this.currentToken.equals("true")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ProtobufFormatter.ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public ByteString consumeByteString() throws ProtobufFormatter.ParseException {
            try {
                String escaped = this.currentToken;
                ByteString result = XmlFormat.unescapeBytes(escaped);
                this.nextToken();
                return result;
            }
            catch (InvalidEscapeSequence e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ProtobufFormatter.ParseException parseException(String description) {
            return new ProtobufFormatter.ParseException(this.line + 1 + ":" + (this.column + 1) + ": " + description);
        }

        public ProtobufFormatter.ParseException parseExceptionPreviousToken(String description) {
            return new ProtobufFormatter.ParseException(this.previousLine + 1 + ":" + (this.previousColumn + 1) + ": " + description);
        }

        private ProtobufFormatter.ParseException integerParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse integer: " + e.getMessage());
        }

        private ProtobufFormatter.ParseException floatParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse number: " + e.getMessage());
        }
    }

    private static final class XmlGenerator {
        Appendable output;

        public XmlGenerator(Appendable output) {
            this.output = output;
        }

        public void print(CharSequence text) throws IOException {
            int size = text.length();
            int pos = 0;
            this.write(text.subSequence(pos, size), size - pos);
        }

        private void write(CharSequence data, int size) throws IOException {
            if (size == 0) {
                return;
            }
            this.output.append(data);
        }
    }
}

