/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Layer;
import java.lang.reflect.Module;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javassist.ClassPath;
import javassist.NotFoundException;

public class ModuleClassPath
implements ClassPath {
    private HashMap packages = new HashMap();

    ModuleClassPath() {
        this(Layer.boot());
    }

    public ModuleClassPath(Layer layer) {
        while (layer != null) {
            Set modules = layer.modules();
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                this.addPackages((Module)it.next());
            }
            layer = layer.parent().orElse(null);
        }
    }

    public ModuleClassPath(Module m) {
        this.addPackages(m);
    }

    private void addPackages(Module m) {
        String[] names = m.getPackages();
        for (int i = 0; i < names.length; ++i) {
            this.packages.put(names[i], m);
        }
    }

    @Override
    public InputStream openClassfile(String classname) throws NotFoundException {
        String filename = classname.replace('.', '/') + ".class";
        Module m = (Module)this.packages.get(ModuleClassPath.getPackageName(classname));
        if (m == null) {
            return null;
        }
        try {
            return m.getResourceAsStream(filename);
        }
        catch (IOException e) {
            throw new NotFoundException(classname, e);
        }
    }

    @Override
    public URL find(String classname) {
        String filename = classname.replace('.', '/') + ".class";
        Module m = (Module)this.packages.get(ModuleClassPath.getPackageName(classname));
        if (m == null) {
            return null;
        }
        try {
            InputStream is = m.getResourceAsStream(filename);
            if (is == null) {
                return null;
            }
            is.close();
            return new URL("jar:file:unknown.jar!/" + filename);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getPackageName(String name) {
        int i = name.lastIndexOf(46);
        if (i > 0) {
            return name.substring(0, i);
        }
        return "";
    }

    @Override
    public void close() {
    }
}

