/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.creator.druid.DruidConfig;
import com.baomidou.dynamic.datasource.toolkit.DsConfigUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(DruidConfigUtil.class);
    private static final String FILTERS = "druid.filters";
    private static final String CONFIG_STR = "config";
    private static final String STAT_STR = "stat";
    private static final Map<String, PropertyDescriptor> CONFIG_DESCRIPTOR_MAP = DsConfigUtil.getPropertyDescriptorMap(DruidConfig.class);
    private static final Map<String, PropertyDescriptor> DATASOURCE_DESCRIPTOR_MAP = DsConfigUtil.getPropertyDescriptorMap(DruidDataSource.class);

    public static Properties toProperties(@NonNull DruidConfig config) {
        String publicKey;
        boolean configFilterExist;
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        Properties properties = new Properties();
        for (Map.Entry<String, PropertyDescriptor> entry : CONFIG_DESCRIPTOR_MAP.entrySet()) {
            String key = entry.getKey();
            PropertyDescriptor descriptor = entry.getValue();
            Method readMethod = descriptor.getReadMethod();
            Class<?> returnType = readMethod.getReturnType();
            if (List.class.isAssignableFrom(returnType) || Set.class.isAssignableFrom(returnType) || Map.class.isAssignableFrom(returnType) || Properties.class.isAssignableFrom(returnType)) continue;
            try {
                Object cValue = readMethod.invoke((Object)config, new Object[0]);
                if (cValue == null) continue;
                properties.setProperty("druid." + key, String.valueOf(cValue));
            }
            catch (Exception e) {
                log.warn("druid current could not set  [" + key + " ]", (Throwable)e);
            }
        }
        String filters = config.getFilters();
        if (filters == null) {
            filters = STAT_STR;
        }
        boolean bl = configFilterExist = (publicKey = config.getPublicKey()) != null && !publicKey.isEmpty();
        if (publicKey != null && !publicKey.isEmpty() && !filters.contains(CONFIG_STR)) {
            filters = filters + ",config";
        }
        properties.setProperty(FILTERS, filters);
        Properties connectProperties = config.getConnectionProperties();
        if (configFilterExist) {
            connectProperties.setProperty("config.decrypt", Boolean.TRUE.toString());
            connectProperties.setProperty("config.decrypt.key", publicKey);
        }
        config.setConnectionProperties(connectProperties);
        return properties;
    }

    public static void setValue(DruidDataSource dataSource, String field, DruidConfig c) {
        try {
            Method configReadMethod = CONFIG_DESCRIPTOR_MAP.get(field).getReadMethod();
            Object value = configReadMethod.invoke((Object)c, new Object[0]);
            if (value != null) {
                PropertyDescriptor descriptor = DATASOURCE_DESCRIPTOR_MAP.get(field);
                if (descriptor == null) {
                    log.warn("druid current not support [" + field + " ]");
                    return;
                }
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod == null) {
                    log.warn("druid current could not set  [" + field + " ]");
                    return;
                }
                writeMethod.invoke((Object)dataSource, value);
            }
        }
        catch (Exception e) {
            log.warn("druid current  set  [" + field + " ] error");
        }
    }

    public static void merge(DruidConfig global, DruidConfig item) {
        PropertyDescriptor[] propertyDescriptors;
        if (global == null) {
            return;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(DruidConfig.class, Object.class);
        for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            Class<?> propertyType = pd.getPropertyType();
            if (Properties.class == propertyType) {
                DruidConfigUtil.mergeProperties(global, item, pd);
                continue;
            }
            if (List.class == propertyType) {
                DruidConfigUtil.mergeList(global, item, pd);
                continue;
            }
            if (Map.class == propertyType) {
                DruidConfigUtil.mergeMap(global, item, pd);
                continue;
            }
            DruidConfigUtil.mergeBasic(global, item, pd);
        }
    }

    private static void mergeList(DruidConfig global, DruidConfig item, PropertyDescriptor pd) {
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        ArrayList result = new ArrayList();
        List itemValue = (List)readMethod.invoke((Object)item, new Object[0]);
        List globalValue = (List)readMethod.invoke((Object)global, new Object[0]);
        if (globalValue != null) {
            result.addAll(globalValue);
        }
        if (itemValue != null) {
            result.addAll(itemValue);
        }
        writeMethod.invoke((Object)item, result);
    }

    private static void mergeMap(DruidConfig global, DruidConfig item, PropertyDescriptor pd) {
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        HashMap result = new HashMap();
        Map itemValue = (Map)readMethod.invoke((Object)item, new Object[0]);
        Map globalValue = (Map)readMethod.invoke((Object)global, new Object[0]);
        if (globalValue != null) {
            result.putAll(globalValue);
        }
        if (itemValue != null) {
            result.putAll(itemValue);
        }
        writeMethod.invoke((Object)item, result);
    }

    private static void mergeProperties(DruidConfig global, DruidConfig item, PropertyDescriptor pd) {
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        Properties itemValue = (Properties)readMethod.invoke((Object)item, new Object[0]);
        Properties globalValue = (Properties)readMethod.invoke((Object)global, new Object[0]);
        Properties properties = new Properties();
        if (globalValue != null) {
            properties.putAll((Map<?, ?>)globalValue);
        }
        if (itemValue != null) {
            properties.putAll((Map<?, ?>)itemValue);
        }
        if (!properties.isEmpty()) {
            writeMethod.invoke((Object)item, properties);
        }
    }

    private static void mergeBasic(DruidConfig global, DruidConfig item, PropertyDescriptor pd) {
        Object globalValue;
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        Object itemValue = readMethod.invoke((Object)item, new Object[0]);
        if (itemValue == null && (globalValue = readMethod.invoke((Object)global, new Object[0])) != null) {
            writeMethod.invoke((Object)item, globalValue);
        }
    }
}

