/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.creator.BasicDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DruidDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.HikariDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.JndiDataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
public class DynamicDataSourceCreatorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceCreatorAutoConfiguration.class);
    private static final int JNDI_ORDER = 1000;
    private static final int DRUID_ORDER = 2000;
    private static final int HIKARI_ORDER = 3000;
    private static final int DEFAULT_ORDER = 5000;
    private final DynamicDataSourceProperties properties;

    @Primary
    @Bean
    @ConditionalOnMissingBean
    public DefaultDataSourceCreator dataSourceCreator(List<DataSourceCreator> dataSourceCreators) {
        DefaultDataSourceCreator defaultDataSourceCreator = new DefaultDataSourceCreator();
        defaultDataSourceCreator.setProperties(this.properties);
        defaultDataSourceCreator.setDataSourceCreators(dataSourceCreators);
        return defaultDataSourceCreator;
    }

    @Bean
    @Order(value=5000)
    @ConditionalOnMissingBean
    public BasicDataSourceCreator basicDataSourceCreator() {
        return new BasicDataSourceCreator();
    }

    @Bean
    @Order(value=1000)
    @ConditionalOnMissingBean
    public JndiDataSourceCreator jndiDataSourceCreator() {
        return new JndiDataSourceCreator();
    }

    public DynamicDataSourceCreatorAutoConfiguration(DynamicDataSourceProperties properties) {
        this.properties = properties;
    }

    @ConditionalOnClass(value={HikariDataSource.class})
    @Configuration
    public class HikariDataSourceCreatorConfiguration {
        @Bean
        @Order(value=3000)
        @ConditionalOnMissingBean
        public HikariDataSourceCreator hikariDataSourceCreator() {
            return new HikariDataSourceCreator(DynamicDataSourceCreatorAutoConfiguration.this.properties.getHikari());
        }
    }

    @ConditionalOnClass(value={DruidDataSource.class})
    @Configuration
    public class DruidDataSourceCreatorConfiguration {
        @Bean
        @Order(value=2000)
        @ConditionalOnMissingBean
        public DruidDataSourceCreator druidDataSourceCreator() {
            return new DruidDataSourceCreator(DynamicDataSourceCreatorAutoConfiguration.this.properties.getDruid());
        }
    }
}

