/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.handler.sharding;

import com.baomidou.mybatisplus.extension.plugins.handler.sharding.ShardingProcessor;
import com.baomidou.mybatisplus.extension.plugins.handler.sharding.ShardingRuleEnum;
import java.util.Arrays;
import java.util.List;

public class ShardingStrategy {
    private String logicTable;
    private String column;
    private ShardingRuleEnum rule;
    private Class<? extends ShardingProcessor> processor;
    private List<String> shardingColumnList;

    public ShardingStrategy(String logicTable, String column, Class<? extends ShardingProcessor> processor) {
        this(logicTable, column, ShardingRuleEnum.ABSOLUTE, processor);
    }

    public ShardingStrategy(String logicTable, String column, ShardingRuleEnum rule, Class<? extends ShardingProcessor> processor) {
        this.logicTable = logicTable;
        this.rule = rule;
        this.processor = processor;
        this.setColumn(column);
    }

    public void setColumn(String column) {
        this.column = column;
        this.shardingColumnList = Arrays.asList(this.column.split(","));
    }

    public boolean containsColumn(String column) {
        return this.shardingColumnList.contains(column);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardingStrategy)) {
            return false;
        }
        ShardingStrategy other = (ShardingStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$logicTable = this.getLogicTable();
        String other$logicTable = other.getLogicTable();
        if (this$logicTable == null ? other$logicTable != null : !this$logicTable.equals(other$logicTable)) {
            return false;
        }
        String this$column = this.column;
        String other$column = other.column;
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        ShardingRuleEnum this$rule = this.getRule();
        ShardingRuleEnum other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !((Object)((Object)this$rule)).equals((Object)other$rule)) {
            return false;
        }
        Class<? extends ShardingProcessor> this$processor = this.getProcessor();
        Class<? extends ShardingProcessor> other$processor = other.getProcessor();
        if (this$processor == null ? other$processor != null : !this$processor.equals(other$processor)) {
            return false;
        }
        List<String> this$shardingColumnList = this.shardingColumnList;
        List<String> other$shardingColumnList = other.shardingColumnList;
        return !(this$shardingColumnList == null ? other$shardingColumnList != null : !((Object)this$shardingColumnList).equals(other$shardingColumnList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardingStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $logicTable = this.getLogicTable();
        result = result * 59 + ($logicTable == null ? 43 : $logicTable.hashCode());
        String $column = this.column;
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        ShardingRuleEnum $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : ((Object)((Object)$rule)).hashCode());
        Class<? extends ShardingProcessor> $processor = this.getProcessor();
        result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
        List<String> $shardingColumnList = this.shardingColumnList;
        result = result * 59 + ($shardingColumnList == null ? 43 : ((Object)$shardingColumnList).hashCode());
        return result;
    }

    public String getLogicTable() {
        return this.logicTable;
    }

    public void setLogicTable(String logicTable) {
        this.logicTable = logicTable;
    }

    public ShardingRuleEnum getRule() {
        return this.rule;
    }

    public void setRule(ShardingRuleEnum rule) {
        this.rule = rule;
    }

    public Class<? extends ShardingProcessor> getProcessor() {
        return this.processor;
    }

    public void setProcessor(Class<? extends ShardingProcessor> processor) {
        this.processor = processor;
    }
}

